/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.panayotis.xray.tree;

import com.panayotis.xray.plugin.XRayPlugin;
import com.panayotis.xray.props.PropertyManagerFactory;
import java.awt.Rectangle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public abstract class PropertyTreePlugin<T> extends javax.swing.JPanel implements XRayPlugin {

    private final PropertyManagerFactory factory;
    private final PropertyTreeModel<T> model;
    private final String name;
    private final int order;
    private T selected = null;
    private JScrollPane props;
    private TimerTask task = new TimerTask() {
        @Override
        public void run() {
            updateTree();
        }
    };

    public PropertyTreePlugin(PropertyTreeModel<T> model, String name) {
        this(model, name, 500);
    }

    public PropertyTreePlugin(PropertyTreeModel<T> model, String name, PropertyManagerFactory factory) {
        this(model, name, 500, factory);
    }

    public PropertyTreePlugin(PropertyTreeModel<T> model, String name, int order) {
        this(model, name, order, new PropertyManagerFactory());
    }

    public PropertyTreePlugin(PropertyTreeModel<T> model, String name, int order, PropertyManagerFactory factory) {
        initComponents();
        tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        tree.setModel(null);
        tree.setUI(new BasicTreeUI() {
            @Override
            public int getRightChildIndent() {
                return 5;
            }

            @Override
            protected int getRowX(int row, int depth) {
                return super.getRowX(row, depth) * 6 / 11;
            }
        });
        this.factory = factory;
        this.name = name;
        this.order = order;
        this.model = model;

        both.setResizeWeight(0.3);

        TreeCellRenderer renderer = model.getTreeDecorator().getRenderer();
        if (renderer != null)
            tree.setCellRenderer(renderer);
    }

    @Override
    public String getPluginName() {
        return name;
    }

    @Override
    public JComponent getPluginVisuals() {
        return this;
    }

    @Override
    public int getPluginOrder() {
        return order;
    }

    @Override
    public void onFocus() {
        updateTree();
    }

    public void addToolbarButton(AbstractButton button) {
        toolbar.add(button, toolbar.getComponentCount() - 4);
    }

    public T getSelectedItem() {
        return selected;
    }

    private void updateTree() {
        tree.setModel(new DefaultTreeModel(new PropertyTreeNode(model)));
        int row = 0;
        TreePath path = null;
        while (row < tree.getRowCount()) {
            tree.expandRow(row);
            if (path == null) {
                path = tree.getPathForRow(row);
                if (((PropertyTreeNode<T>) path.getLastPathComponent()).getItem() != selected)
                    path = null;// still not found
            }
            row++;
        }
        if (path != null)
            tree.getSelectionModel().setSelectionPath(path);
        tree.setRootVisible(model.isRootVisible());
        tree.setShowsRootHandles(true);
    }

    private void updateProperties() {
        if (selected != null) {
            Rectangle pos = null;
            if (props != null) {
                pos = props.getViewport().getViewRect();
                both.remove(props);
            }
            props = new JScrollPane(factory.getView(selected));
            both.setRightComponent(props);
            props.getVerticalScrollBar().setUnitIncrement(20);
            if (pos != null)
                props.getViewport().scrollRectToVisible(pos);
            both.validate();
        }
    }

    public PropertyManagerFactory getFactory() {
        return factory;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        toolbar = new javax.swing.JToolBar();
        onceB = new javax.swing.JToggleButton();
        timedB = new javax.swing.JToggleButton();
        both = new javax.swing.JSplitPane();
        treeView = new javax.swing.JScrollPane();
        tree = new javax.swing.JTree();
        jLabel1 = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        toolbar.setFloatable(false);
        toolbar.setRollover(true);

        onceB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/reload1.png"))); // NOI18N
        onceB.setFocusable(false);
        onceB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        onceB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        onceB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                onceBActionPerformed(evt);
            }
        });
        toolbar.add(onceB);

        timedB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/reload.png"))); // NOI18N
        timedB.setFocusable(false);
        timedB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        timedB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        timedB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                timedBActionPerformed(evt);
            }
        });
        toolbar.add(timedB);

        add(toolbar, java.awt.BorderLayout.NORTH);

        both.setDividerSize(7);

        treeView.setMinimumSize(new java.awt.Dimension(20, 50));

        tree.setMinimumSize(new java.awt.Dimension(30, 30));
        tree.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
            public void valueChanged(javax.swing.event.TreeSelectionEvent evt) {
                treeValueChanged(evt);
            }
        });
        treeView.setViewportView(tree);

        both.setLeftComponent(treeView);

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setText("No item is selected yet");
        both.setRightComponent(jLabel1);

        add(both, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void onceBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_onceBActionPerformed
        onceB.setEnabled(false);
        timedB.setEnabled(false);
        SwingUtilities.invokeLater(() -> {
            updateTree();
            Timer t = new Timer();
            t.schedule(new TimerTask() {
                @Override
                public void run() {
                    onceB.setEnabled(true);
                    timedB.setEnabled(true);
                    onceB.setSelected(false);
                    t.cancel();
                }
            }, 1);
        });
    }//GEN-LAST:event_onceBActionPerformed

    private void treeValueChanged(javax.swing.event.TreeSelectionEvent evt) {//GEN-FIRST:event_treeValueChanged
        selected = ((PropertyTreeNode<T>) evt.getPath().getLastPathComponent()).getItem();
        updateProperties();
    }//GEN-LAST:event_treeValueChanged

    private void timedBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_timedBActionPerformed
        if (timedB.isSelected()) {
            onceB.setEnabled(false);
            if (task != null)
                new Timer().scheduleAtFixedRate(task, 0, 1000);
        } else if (task != null) {
            task.cancel();
            onceB.setEnabled(true);
            task = null;
        }
    }//GEN-LAST:event_timedBActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSplitPane both;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JToggleButton onceB;
    private javax.swing.JToggleButton timedB;
    private javax.swing.JToolBar toolbar;
    private javax.swing.JTree tree;
    private javax.swing.JScrollPane treeView;
    // End of variables declaration//GEN-END:variables

}
