/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray;

import com.panayotis.xray.plugin.PluginManager;
import com.panayotis.xray.plugin.XRayPlugin;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class XRayWindow
extends JFrame {
    private ButtonGroup buttongroup;
    private JPanel panel;
    private JPanel toolbar;
    private JPanel viewarea;

    public XRayWindow() {
        super("XRay Application");
        this.initComponents();
        this.init();
    }

    private void init() {
        AbstractButton first = null;
        for (XRayPlugin plugin : PluginManager.plugins()) {
            String name = plugin.getPluginName();
            JToggleButton button = new JToggleButton(plugin.getPluginName());
            JComponent visual = plugin.getPluginVisuals();
            this.toolbar.add(button);
            this.buttongroup.add(button);
            this.viewarea.add((Component)visual, name);
            button.addActionListener(e -> {
                ((CardLayout)this.viewarea.getLayout()).show(this.viewarea, name);
                plugin.onFocus();
            });
            if (first != null) continue;
            first = button;
        }
        if (first != null) {
            first.setSelected(true);
        }
    }

    private void initComponents() {
        this.buttongroup = new ButtonGroup();
        this.panel = new JPanel();
        this.viewarea = new JPanel();
        this.toolbar = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 300));
        this.getContentPane().setLayout(new BorderLayout(5, 0));
        this.panel.setLayout(new BorderLayout());
        this.viewarea.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
        this.viewarea.setLayout(new CardLayout());
        this.panel.add((Component)this.viewarea, "Center");
        this.toolbar.setLayout(new FlowLayout(0));
        this.panel.add((Component)this.toolbar, "North");
        this.getContentPane().add((Component)this.panel, "Center");
        this.pack();
    }
}

