/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.plugin;

import com.panayotis.xray.plugin.XRayPlugin;
import com.panayotis.xray.utils.EnumToIterable;
import com.panayotis.xray.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PluginManager {
    private static final String PLUGIN_LOC = "META-INF/xray-plugins/";
    private static Collection<XRayPlugin> plugins;

    public static Collection<XRayPlugin> plugins() {
        if (plugins == null) {
            plugins = new TreeSet<XRayPlugin>((o1, o2) -> o1.getPluginOrder() - o2.getPluginOrder());
            for (URL url : ((URLClassLoader)PluginManager.class.getClassLoader()).getURLs()) {
                try {
                    PluginManager.readPlugins(new File(Paths.get(url.toURI()).toString()), plugins);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return plugins;
    }

    private static void readPlugins(File path, Collection<XRayPlugin> plugins) throws IOException {
        block4: {
            block3: {
                if (!path.isDirectory()) break block3;
                if (!(path = new File(path, PLUGIN_LOC)).exists() || !path.isDirectory()) {
                    return;
                }
                for (File possible : path.listFiles()) {
                    if (!possible.isFile()) continue;
                    PluginManager.loadPlugin(possible.getName(), plugins);
                }
                break block4;
            }
            if (!path.isFile()) break block4;
            JarFile jar = new JarFile(path);
            for (JarEntry entry : EnumToIterable.toIterable(jar.entries())) {
                if (entry.isDirectory() || !entry.getName().startsWith(PLUGIN_LOC)) continue;
                PluginManager.loadPlugin(entry.getName().substring(PLUGIN_LOC.length()), plugins);
            }
        }
    }

    private static void loadPlugin(String name, Collection<XRayPlugin> plugins) {
        if (name == null || name.isEmpty()) {
            return;
        }
        try {
            plugins.add((XRayPlugin)Class.forName(name).newInstance());
        }
        catch (Exception ex) {
            Logger.error("Unable to instantiate plugin '" + name + "'");
            Logger.error(ex.toString());
        }
    }
}

