/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.props;

import java.lang.reflect.Method;
import javax.swing.JComponent;

public abstract class PropertyManager<T> {
    private final String name;
    private final Object instance;
    private final Method setter;
    private final Method getter;
    private JComponent view;
    private boolean setValueLock = false;

    public PropertyManager(Object instance, String name, Method setter, Method getter) {
        this.instance = instance;
        this.name = name;
        this.setter = setter;
        this.getter = getter;
    }

    public final JComponent getView() {
        if (this.view == null) {
            this.view = this.createView();
            this.setValueLock = true;
            this.updateView(this.getValue());
            this.setValueLock = false;
        }
        return this.view;
    }

    public final String toString() {
        try {
            T result = this.getValue();
            if (result != null) {
                return result.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected final boolean setValue(T newValue) {
        if (this.setValueLock) {
            return true;
        }
        this.setValueLock = true;
        if (this.setter != null) {
            try {
                this.setter.invoke(this.instance, newValue);
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
            }
            finally {
                this.updateView(this.getValue());
                this.setValueLock = false;
            }
        }
        return false;
    }

    protected final T getValue() {
        try {
            return (T)this.getter.invoke(this.instance, (Object[])null);
        }
        catch (Exception ex) {
            return this.defaultValue();
        }
    }

    protected final boolean isReadOnly() {
        return this.setter == null;
    }

    protected final String getName() {
        return this.name;
    }

    protected abstract JComponent createView();

    public abstract void updateView(T var1);

    protected abstract T defaultValue();
}

