/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.props;

import com.panayotis.xray.props.BeanPropertyRecognizer;
import com.panayotis.xray.props.PropertyGenerator;
import com.panayotis.xray.props.PropertyManager;
import com.panayotis.xray.props.PropertyRecognizer;
import com.panayotis.xray.props.PropertyResolver;
import com.panayotis.xray.props.visuals.ConstrainedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PropertyManagerFactory {
    private final PropertyResolver resolv;
    private final PropertyRecognizer recogn;
    private final Map<Class, Map<String, PropMethod>> registry = new HashMap<Class, Map<String, PropMethod>>();

    public PropertyManagerFactory() {
        this(null, null);
    }

    public PropertyManagerFactory(PropertyRecognizer recogn) {
        this(null, recogn);
    }

    public PropertyManagerFactory(PropertyResolver resolv) {
        this(resolv, null);
    }

    public PropertyManagerFactory(PropertyResolver resolv, PropertyRecognizer recogn) {
        if (resolv == null) {
            resolv = new PropertyResolver();
        }
        if (recogn == null) {
            recogn = new BeanPropertyRecognizer();
        }
        this.resolv = resolv;
        this.recogn = recogn;
    }

    public <T> void register(Class<T> type, Class<? extends PropertyManager<T>> generator) {
        this.resolv.register(type, (Object instance, String name, Method setter, Method getter) -> {
            try {
                return (PropertyManager)generator.getConstructor(Object.class, String.class, Method.class, Method.class).newInstance(instance, name, setter, getter);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public <T> void register(Class<T> type, PropertyGenerator<T> generator) {
        this.resolv.register(type, generator);
    }

    public JComponent getView(Object instance) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        ConstrainedPanel titlePanel = new ConstrainedPanel(new BorderLayout());
        JLabel title = new JLabel(instance.getClass().getName());
        JLabel hash = new JLabel("@" + Integer.toHexString(instance.hashCode()));
        hash.setHorizontalAlignment(2);
        title.setFont(title.getFont().deriveFont(1));
        titlePanel.add((Component)title, "West");
        titlePanel.add((Component)hash, "Center");
        panel.add(titlePanel);
        Map<String, PropMethod> methods = this.retrieveList(instance);
        for (String prop : methods.keySet()) {
            PropMethod method = methods.get(prop);
            PropertyManager pman = this.resolv.resolve(instance, this.recogn.getNameFromGetter(method.getter), method.setter, method.getter);
            ConstrainedPanel constraint = new ConstrainedPanel(new BorderLayout());
            constraint.add((Component)pman.getView(), "Center");
            panel.add(constraint);
        }
        return panel;
    }

    private Map<String, PropMethod> retrieveList(Object instance) {
        Class<?> cls = instance.getClass();
        Map<String, PropMethod> objmap = this.registry.get(cls);
        if (objmap == null) {
            objmap = new TreeMap<String, PropMethod>();
            this.registry.put(cls, objmap);
            for (Method m : cls.getMethods()) {
                if (this.recogn.isSetter(m)) {
                    PropertyManagerFactory.getValue(objmap, this.recogn.getNameFromSetter(m), () -> new PropMethod()).setter = m;
                    continue;
                }
                if (!this.recogn.isGetter(m)) continue;
                PropertyManagerFactory.getValue(objmap, this.recogn.getNameFromGetter(m), () -> new PropMethod()).getter = m;
            }
            Iterator<String> props = objmap.keySet().iterator();
            while (props.hasNext()) {
                String prop = props.next();
                PropMethod method = objmap.get(prop);
                if (method.getter != null) continue;
                props.remove();
            }
        }
        return objmap;
    }

    static <K, V> V getValue(Map<K, V> map, K key, Supplier<V> keyConstructor) {
        V val = map.get(key);
        if (val == null) {
            val = keyConstructor.get();
            map.put(key, val);
        }
        return val;
    }

    static class PropMethod {
        private Method getter;
        private Method setter;

        PropMethod() {
        }
    }
}

