/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.props.commons;

import com.panayotis.xray.props.PropertyManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.lang.reflect.Method;
import java.util.function.Function;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class ColorPropertyManager<C>
extends PropertyManager<C> {
    private final JPanel visuals;
    private final JPanel colorDisplay;
    private final Function<C, Color> fromData;
    private C ccolor;

    public ColorPropertyManager(Object instance, String name, Method setter, Method getter, Function<Color, C> toData, Function<C, Color> fromData) {
        super(instance, name, setter, getter);
        this.fromData = fromData;
        this.visuals = new JPanel(new GridLayout(1, 2));
        JPanel cpanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(name);
        JButton popup = new JButton("Edit");
        this.colorDisplay = new JPanel();
        if (this.isReadOnly()) {
            label.setEnabled(false);
            popup.setEnabled(false);
        }
        popup.addActionListener(e -> {
            Color c = JColorChooser.showDialog(popup, name, (Color)fromData.apply(this.ccolor == null ? this.defaultValue() : this.ccolor));
            if (c != null) {
                this.setValue(toData.apply(c));
            }
        });
        cpanel.add((Component)this.colorDisplay, "Center");
        cpanel.add((Component)popup, "East");
        this.visuals.add(label);
        this.visuals.add(cpanel);
    }

    @Override
    protected JComponent createView() {
        return this.visuals;
    }

    @Override
    public void updateView(C value) {
        this.ccolor = value;
        this.colorDisplay.setBackground(this.fromData.apply(this.ccolor));
    }
}

