/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.props.commons;

import com.panayotis.xray.props.PropertyManager;
import com.panayotis.xray.props.visuals.DoubleNumberPropertyVisuals;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.swing.JComponent;

public abstract class NumericPairPropertyManager<N extends Number, T>
extends PropertyManager<T> {
    private final DoubleNumberPropertyVisuals<N> visuals;
    private final Function<T, N[]> fromData;

    public NumericPairPropertyManager(Object instance, String name, Method setter, Method getter, N min, N max, BiFunction<N, N, T> toData, Function<T, N[]> fromData) {
        super(instance, name, setter, getter);
        this.visuals = new DoubleNumberPropertyVisuals<N>(min, max);
        this.visuals.setEnabled(!this.isReadOnly());
        this.visuals.addListener((x, y) -> this.setValue(toData.apply(x, y)));
        this.visuals.setLabelName(name);
        this.fromData = fromData;
    }

    @Override
    protected JComponent createView() {
        return this.visuals;
    }

    @Override
    public void updateView(T item) {
        if (item != null) {
            Number[] val = (Number[])this.fromData.apply(item);
            this.visuals.update(val[0], val[1]);
        }
    }
}

