/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.props.commons;

import com.panayotis.xray.props.PropertyManager;
import com.panayotis.xray.props.visuals.DoubleNumberPropertyVisuals;
import com.panayotis.xray.utils.QuadFunction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.lang.reflect.Method;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class NumericQuadPropertyManager<N extends Number, T>
extends PropertyManager<T> {
    private final DoubleNumberPropertyVisuals<N> top;
    private final DoubleNumberPropertyVisuals<N> bottom;
    private final JPanel visuals;
    private final Function<T, N[]> fromData;
    private N topA;
    private N topB;
    private N bottomC;
    private N bottomD;

    public NumericQuadPropertyManager(Object instance, String name, Method setter, Method getter, N minTop, N maxTop, N minBottom, N maxBottom, String topLabel, String bottomLabel, QuadFunction<N, N, N, N, T> toData, Function<T, N[]> fromData) {
        super(instance, name, setter, getter);
        this.topA = minTop;
        this.topB = maxTop;
        this.bottomC = minBottom;
        this.bottomD = maxBottom;
        this.visuals = new JPanel(new BorderLayout());
        JLabel nameL = new JLabel(name);
        this.top = new DoubleNumberPropertyVisuals<N>(minTop, maxTop);
        this.bottom = new DoubleNumberPropertyVisuals<N>(minBottom, maxBottom);
        if (this.isReadOnly()) {
            nameL.setEnabled(false);
            this.top.setEnabled(false);
            this.bottom.setEnabled(false);
        }
        this.top.addListener((a, b) -> {
            this.topA = a;
            this.topB = b;
            this.setValue(toData.apply(this.topA, this.topB, this.bottomC, this.bottomD));
        });
        this.bottom.addListener((c, d) -> {
            this.bottomC = c;
            this.bottomD = d;
            this.setValue(toData.apply(this.topA, this.topB, this.bottomC, this.bottomD));
        });
        if (topLabel != null) {
            this.top.setLabelName("  " + topLabel);
        }
        if (bottomLabel != null) {
            this.bottom.setLabelName("  " + bottomLabel);
        }
        this.visuals.add((Component)nameL, "North");
        JPanel spinners = new JPanel(new GridLayout(2, 1));
        spinners.add(this.top);
        spinners.add(this.bottom);
        this.visuals.add((Component)spinners, "Center");
        this.fromData = fromData;
    }

    @Override
    protected JComponent createView() {
        return this.visuals;
    }

    @Override
    public void updateView(T item) {
        if (item != null) {
            Number[] val = (Number[])this.fromData.apply(item);
            this.topA = val[0];
            this.topB = val[1];
            this.top.update((Number)this.topA, (Number)this.topB);
            this.bottomC = val[2];
            this.bottomD = val[3];
            this.bottom.update((Number)this.bottomC, (Number)this.bottomD);
        }
    }
}

