/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.props.visuals;

import com.panayotis.xray.props.visuals.AwareDefaults;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

public class AwareSpinner<N extends Number>
extends JPanel {
    private final JSpinner spinner;
    private final SpinnerNumberModel model;

    public AwareSpinner(N min, N max) {
        super(new BorderLayout());
        this.model = new SpinnerNumberModel(this.num(min, 0), (Comparable)min, (Comparable)max, this.num(min, 1));
        this.spinner = new JSpinner(this.model);
        this.spinner.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AwareSpinner.this.setOpaque(e.getKeyCode() != 10);
            }
        });
        this.add((Component)this.spinner, "Center");
        this.setOpaque(false);
        this.setBackground(AwareDefaults.DIRTY);
    }

    public N getValue() {
        return (N)this.model.getNumber();
    }

    public void setValue(Number n) {
        this.model.setValue(n);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.spinner.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void addChangeListener(ChangeListener listener) {
        this.spinner.addChangeListener(listener);
    }

    private Number num(N number, int basenum) {
        if (number instanceof Byte) {
            return (byte)basenum;
        }
        if (number instanceof Short) {
            return (short)basenum;
        }
        if (number instanceof Integer) {
            return basenum;
        }
        if (number instanceof Long) {
            return (long)basenum;
        }
        if (number instanceof Float) {
            return Float.valueOf(basenum);
        }
        if (number instanceof Double) {
            return (double)basenum;
        }
        return null;
    }
}

