/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.tree;

import com.panayotis.xray.tree.PropertyTreeModel;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

public class PropertyTreeNode<T>
implements TreeNode {
    private final T thisItem;
    private final PropertyTreeNode<T> parent;
    private final PropertyTreeModel<T> model;
    private List<? extends T> children;

    public PropertyTreeNode(PropertyTreeModel<T> model) {
        this(model, model.getRoot(), null);
    }

    private PropertyTreeNode(PropertyTreeModel<T> model, T thisItem, PropertyTreeNode<T> parentItem) {
        this.model = model;
        this.thisItem = thisItem;
        this.parent = parentItem;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (this.thisItem == null) {
            return -1;
        }
        int idx = -1;
        for (T child : this.lazyChildren()) {
            ++idx;
            if (child != node) continue;
            return idx;
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        if (this.thisItem == null) {
            return true;
        }
        return this.model.isLeaf(this.thisItem);
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return new PropertyTreeNode<T>(this.model, this.lazyChildren().get(childIndex), this);
    }

    @Override
    public int getChildCount() {
        if (this.thisItem == null) {
            return -1;
        }
        return this.lazyChildren().size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public Enumeration children() {
        return new Enumeration(){
            int upTo;
            int idx;
            {
                this.upTo = PropertyTreeNode.this.getChildCount();
                this.idx = 0;
            }

            @Override
            public boolean hasMoreElements() {
                return this.idx < this.upTo;
            }

            public Object nextElement() {
                return PropertyTreeNode.this.getChildAt(this.idx++);
            }
        };
    }

    public T getItem() {
        return this.thisItem;
    }

    private List<? extends T> lazyChildren() {
        if (this.children == null) {
            this.children = this.model.getChildren(this.thisItem);
            if (this.children == null) {
                this.children = Collections.EMPTY_LIST;
            }
        }
        return this.children;
    }
}

