/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.tree;

import com.panayotis.xray.plugin.XRayPlugin;
import com.panayotis.xray.props.PropertyManagerFactory;
import com.panayotis.xray.tree.PropertyTreeModel;
import com.panayotis.xray.tree.PropertyTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public abstract class PropertyTreePlugin<T>
extends JPanel
implements XRayPlugin {
    private final PropertyManagerFactory factory;
    private final PropertyTreeModel<T> model;
    private final String name;
    private final int order;
    private T selected = null;
    private JScrollPane props;
    private TimerTask task = new TimerTask(){

        @Override
        public void run() {
            PropertyTreePlugin.this.updateTree();
        }
    };
    private JSplitPane both;
    private JLabel jLabel1;
    private JToggleButton onceB;
    private JToggleButton timedB;
    private JToolBar toolbar;
    private JTree tree;
    private JScrollPane treeView;

    public PropertyTreePlugin(PropertyTreeModel<T> model, String name) {
        this(model, name, 500);
    }

    public PropertyTreePlugin(PropertyTreeModel<T> model, String name, PropertyManagerFactory factory) {
        this(model, name, 500, factory);
    }

    public PropertyTreePlugin(PropertyTreeModel<T> model, String name, int order) {
        this(model, name, order, new PropertyManagerFactory());
    }

    public PropertyTreePlugin(PropertyTreeModel<T> model, String name, int order, PropertyManagerFactory factory) {
        this.initComponents();
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setModel(null);
        this.tree.setUI(new BasicTreeUI(){

            @Override
            public int getRightChildIndent() {
                return 5;
            }

            @Override
            protected int getRowX(int row, int depth) {
                return super.getRowX(row, depth) * 6 / 11;
            }
        });
        this.factory = factory;
        this.name = name;
        this.order = order;
        this.model = model;
        this.both.setResizeWeight(0.3);
        TreeCellRenderer renderer = model.getTreeDecorator().getRenderer();
        if (renderer != null) {
            this.tree.setCellRenderer(renderer);
        }
    }

    @Override
    public String getPluginName() {
        return this.name;
    }

    @Override
    public JComponent getPluginVisuals() {
        return this;
    }

    @Override
    public int getPluginOrder() {
        return this.order;
    }

    @Override
    public void onFocus() {
        this.updateTree();
    }

    public void addToolbarButton(AbstractButton button) {
        this.toolbar.add((Component)button, this.toolbar.getComponentCount() - 4);
    }

    public T getSelectedItem() {
        return this.selected;
    }

    private void updateTree() {
        this.tree.setModel(new DefaultTreeModel(new PropertyTreeNode<T>(this.model)));
        TreePath path = null;
        for (int row = 0; row < this.tree.getRowCount(); ++row) {
            this.tree.expandRow(row);
            if (path != null || ((PropertyTreeNode)(path = this.tree.getPathForRow(row)).getLastPathComponent()).getItem() == this.selected) continue;
            path = null;
        }
        if (path != null) {
            this.tree.getSelectionModel().setSelectionPath(path);
        }
        this.tree.setRootVisible(this.model.isRootVisible());
        this.tree.setShowsRootHandles(true);
    }

    private void updateProperties() {
        if (this.selected != null) {
            Rectangle pos = null;
            if (this.props != null) {
                pos = this.props.getViewport().getViewRect();
                this.both.remove(this.props);
            }
            this.props = new JScrollPane(this.factory.getView(this.selected));
            this.both.setRightComponent(this.props);
            this.props.getVerticalScrollBar().setUnitIncrement(20);
            if (pos != null) {
                this.props.getViewport().scrollRectToVisible(pos);
            }
            this.both.validate();
        }
    }

    public PropertyManagerFactory getFactory() {
        return this.factory;
    }

    private void initComponents() {
        this.toolbar = new JToolBar();
        this.onceB = new JToggleButton();
        this.timedB = new JToggleButton();
        this.both = new JSplitPane();
        this.treeView = new JScrollPane();
        this.tree = new JTree();
        this.jLabel1 = new JLabel();
        this.setLayout(new BorderLayout());
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.onceB.setIcon(new ImageIcon(this.getClass().getResource("/icons/reload1.png")));
        this.onceB.setFocusable(false);
        this.onceB.setHorizontalTextPosition(0);
        this.onceB.setVerticalTextPosition(3);
        this.onceB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyTreePlugin.this.onceBActionPerformed(evt);
            }
        });
        this.toolbar.add(this.onceB);
        this.timedB.setIcon(new ImageIcon(this.getClass().getResource("/icons/reload.png")));
        this.timedB.setFocusable(false);
        this.timedB.setHorizontalTextPosition(0);
        this.timedB.setVerticalTextPosition(3);
        this.timedB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyTreePlugin.this.timedBActionPerformed(evt);
            }
        });
        this.toolbar.add(this.timedB);
        this.add((Component)this.toolbar, "North");
        this.both.setDividerSize(7);
        this.treeView.setMinimumSize(new Dimension(20, 50));
        this.tree.setMinimumSize(new Dimension(30, 30));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                PropertyTreePlugin.this.treeValueChanged(evt);
            }
        });
        this.treeView.setViewportView(this.tree);
        this.both.setLeftComponent(this.treeView);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("No item is selected yet");
        this.both.setRightComponent(this.jLabel1);
        this.add((Component)this.both, "Center");
    }

    private void onceBActionPerformed(ActionEvent evt) {
        this.onceB.setEnabled(false);
        this.timedB.setEnabled(false);
        SwingUtilities.invokeLater(() -> {
            this.updateTree();
            final Timer t = new Timer();
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    PropertyTreePlugin.this.onceB.setEnabled(true);
                    PropertyTreePlugin.this.timedB.setEnabled(true);
                    PropertyTreePlugin.this.onceB.setSelected(false);
                    t.cancel();
                }
            }, 1L);
        });
    }

    private void treeValueChanged(TreeSelectionEvent evt) {
        this.selected = ((PropertyTreeNode)evt.getPath().getLastPathComponent()).getItem();
        this.updateProperties();
    }

    private void timedBActionPerformed(ActionEvent evt) {
        if (this.timedB.isSelected()) {
            this.onceB.setEnabled(false);
            if (this.task != null) {
                new Timer().scheduleAtFixedRate(this.task, 0L, 1000L);
            }
        } else if (this.task != null) {
            this.task.cancel();
            this.onceB.setEnabled(true);
            this.task = null;
        }
    }
}

