/*
 * Decompiled with CFR 0.152.
 */
package com.panforge.robotstxt;

import com.panforge.robotstxt.Grant;
import com.panforge.robotstxt.Group;
import com.panforge.robotstxt.MatchingStrategy;
import java.util.Collections;
import java.util.List;

class Access
implements Grant {
    private final Group group;
    private final String source;
    private final String clause;
    private final boolean accessAllowed;

    public Access(Group group, String source, String clause, boolean accessAllowed) {
        this.group = group;
        this.source = source;
        this.clause = clause;
        this.accessAllowed = accessAllowed;
    }

    @Override
    public String getClause() {
        return this.clause;
    }

    @Override
    public boolean hasAccess() {
        return this.accessAllowed;
    }

    @Override
    public Integer getCrawlDelay() {
        return this.group != null ? this.group.getCrawlDelay() : null;
    }

    @Override
    public List<String> getUserAgents() {
        return this.group != null ? this.group.getUserAgents() : Collections.emptyList();
    }

    public boolean matches(String path, MatchingStrategy matchingStrategy) {
        return path != null && matchingStrategy.matches(this.clause, path);
    }

    public String toString() {
        return this.source;
    }
}

