/*
 * Decompiled with CFR 0.152.
 */
package com.panforge.robotstxt;

import com.panforge.robotstxt.Access;
import com.panforge.robotstxt.MatchingStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class AccessList {
    private final List<Access> accessList = new ArrayList<Access>();

    AccessList() {
    }

    public void addAccess(Access access) {
        this.accessList.add(access);
    }

    public void importAccess(AccessList ref) {
        this.accessList.addAll(ref.accessList);
    }

    public String toString() {
        return this.accessList.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }

    public List<Access> select(String relativePath, MatchingStrategy matchingStrategy) {
        ArrayList<Access> allMatching = new ArrayList<Access>();
        if (relativePath != null) {
            for (Access acc : this.accessList) {
                if (!acc.matches(relativePath, matchingStrategy)) continue;
                allMatching.add(acc);
            }
        }
        return allMatching;
    }

    public List<Access> listAll() {
        return this.accessList;
    }
}

