/*
 * Decompiled with CFR 0.152.
 */
package com.panforge.robotstxt;

import com.panforge.robotstxt.Access;
import com.panforge.robotstxt.AccessList;
import com.panforge.robotstxt.MatchingStrategy;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class Group {
    private final List<String> userAgents = new ArrayList<String>();
    private final AccessList accessList = new AccessList();
    private boolean anyAgent;
    private Integer crawlDelay;

    Group() {
    }

    public boolean isAnyAgent() {
        return this.anyAgent;
    }

    public boolean isExact(Group group) {
        if (this.isAnyAgent() && group.isAnyAgent()) {
            return true;
        }
        if (this.isAnyAgent() && !group.isAnyAgent() || !this.isAnyAgent() && group.isAnyAgent()) {
            return false;
        }
        return group.userAgents.stream().anyMatch(sectionUserAgent -> this.userAgents.stream().anyMatch(userAgent -> userAgent.equalsIgnoreCase((String)sectionUserAgent)));
    }

    public void addUserAgent(String userAgent) {
        if (userAgent.equals("*")) {
            this.anyAgent = true;
        } else {
            this.userAgents.add(userAgent);
        }
    }

    public AccessList getAccessList() {
        return this.accessList;
    }

    public void addAccess(Access access) {
        this.accessList.addAccess(access);
    }

    public List<String> getUserAgents() {
        return this.userAgents;
    }

    public List<Access> select(String userAgent, String relativePath, MatchingStrategy matchingStrategy) {
        if (userAgent == null && !this.isAnyAgent() || relativePath == null || !this.matchUserAgent(userAgent)) {
            return Collections.EMPTY_LIST;
        }
        return this.accessList.select(relativePath, matchingStrategy).stream().collect(Collectors.toList());
    }

    public boolean matchUserAgent(String userAgent) {
        if (this.anyAgent) {
            return true;
        }
        if (!this.anyAgent && userAgent == null) {
            return false;
        }
        return this.userAgents.stream().anyMatch(agent -> agent.equalsIgnoreCase(userAgent));
    }

    public void setCrawlDelay(Integer crawlDelay) {
        this.crawlDelay = crawlDelay;
    }

    public Integer getCrawlDelay() {
        return this.crawlDelay;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (this.anyAgent) {
            pw.format("User-agent: %s", "*").println();
        }
        this.userAgents.forEach(userAgent -> pw.format("User-agent: %s", userAgent).println());
        pw.println(this.accessList);
        if (this.crawlDelay != null) {
            pw.format("Crawl-delay: %d", this.crawlDelay).println();
        }
        pw.flush();
        return sw.toString();
    }
}

