/*
 * Decompiled with CFR 0.152.
 */
package com.panforge.robotstxt;

import com.panforge.robotstxt.TimeLimitedMatcherFactory;
import com.panforge.robotstxt.URLDecoder;
import com.panforge.robotstxt.WildcardsCompiler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

interface MatchingStrategy {
    public static final MatchingStrategy DEFAULT = (pattern, pathToTest) -> {
        if (pathToTest == null) {
            return false;
        }
        if (pattern == null || pattern.isEmpty()) {
            return true;
        }
        String relativePath = URLDecoder.decode(pathToTest);
        try {
            Pattern pt = WildcardsCompiler.compile(pattern);
            Matcher timeBoundMatcher = TimeLimitedMatcherFactory.matcher(pt, relativePath);
            return timeBoundMatcher.find() && timeBoundMatcher.start() == 0;
        }
        catch (TimeLimitedMatcherFactory.RegExpTimeoutException e) {
            return false;
        }
    };

    public boolean matches(String var1, String var2);
}

