/*
 * Decompiled with CFR 0.152.
 */
package com.panforge.robotstxt;

import com.panforge.robotstxt.Access;
import com.panforge.robotstxt.Grant;
import com.panforge.robotstxt.Group;
import com.panforge.robotstxt.MatchingStrategy;
import com.panforge.robotstxt.RobotsTxt;
import com.panforge.robotstxt.StringUtils;
import com.panforge.robotstxt.WinningStrategy;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class RobotsTxtImpl
implements RobotsTxt {
    private Group defaultSection;
    private final List<Group> groups = new ArrayList<Group>();
    private Integer crawlDelay;
    private String host;
    private final List<String> sitemaps = new ArrayList<String>();
    private final MatchingStrategy matchingStrategy;
    private final WinningStrategy winningStrategy;

    public RobotsTxtImpl(MatchingStrategy matchingStrategy, WinningStrategy winningStrategy) {
        this.matchingStrategy = matchingStrategy;
        this.winningStrategy = winningStrategy;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public List<String> getSitemaps() {
        return this.sitemaps;
    }

    @Deprecated
    public void setCrawlDelay(Integer crawlDelay) {
        this.crawlDelay = crawlDelay;
    }

    @Override
    public Integer getCrawlDelay() {
        return this.crawlDelay;
    }

    @Override
    public List<String> getDisallowList(String userAgent) {
        Group sec = this.findSectionByAgent(this.groups, userAgent, this.defaultSection);
        return sec != null ? sec.getAccessList().listAll().stream().filter(acc -> !acc.hasAccess()).map(Access::getClause).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public boolean query(String userAgent, String path) {
        Grant grant = this.ask(userAgent, path);
        return grant.hasAccess();
    }

    @Override
    public Grant ask(String userAgent, String path) {
        List<Access> select = this.select(userAgent, path).stream().collect(Collectors.toList());
        Access winner = this.winningStrategy.selectWinner(select);
        return winner != null ? winner : this.createDefaultAccess();
    }

    public void addGroup(Group section) {
        if (section != null) {
            if (section.isAnyAgent()) {
                if (this.defaultSection == null) {
                    this.defaultSection = section;
                } else {
                    this.defaultSection.getAccessList().importAccess(section.getAccessList());
                }
            } else {
                Group exact = this.findExactSection(section);
                if (exact == null) {
                    this.groups.add(section);
                } else {
                    exact.getAccessList().importAccess(section.getAccessList());
                }
            }
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (this.defaultSection != null) {
            pw.println(this.defaultSection);
        }
        this.groups.forEach(pw::println);
        if (this.host != null) {
            pw.format("Host: %s", this.host).println();
        }
        this.sitemaps.forEach(sitemap -> pw.format("Sitemap: %s", sitemap).println());
        pw.flush();
        return sw.toString();
    }

    private Group findExactSection(Group section) {
        for (Group s : this.groups) {
            if (!s.isExact(section)) continue;
            return s;
        }
        return null;
    }

    private List<Access> select(String userAgent, String path) {
        String relativePath = this.assureRelative(path);
        if (relativePath != null && !"/robots.txt".equalsIgnoreCase(relativePath)) {
            ArrayList<Access> selected = new ArrayList<Access>();
            Group sec = this.findSectionByAgent(this.groups, userAgent, this.defaultSection);
            if (sec != null) {
                selected.addAll(sec.select(userAgent, relativePath, this.matchingStrategy));
            }
            if (selected.isEmpty()) {
                selected.add(this.createDefaultAccess());
            }
            return selected;
        }
        return Collections.EMPTY_LIST;
    }

    private Group findSectionByAgent(List<Group> sections, String userAgent, Group defaultGroup) {
        List<Group> candidateGroups = this.getCandidateGroupsByAgent(sections, userAgent);
        if (candidateGroups.isEmpty()) {
            return defaultGroup;
        }
        return this.findBestMatchingSectionByAgent(candidateGroups, userAgent);
    }

    private List<Group> getCandidateGroupsByAgent(List<Group> sections, String userAgent) {
        return sections.stream().filter(sec -> sec.matchUserAgent(userAgent)).collect(Collectors.toList());
    }

    private Group findBestMatchingSectionByAgent(List<Group> sections, String userAgent) {
        int longestMatch = 0;
        Group bestMatch = null;
        for (Group sec : sections) {
            for (String agent : sec.getUserAgents()) {
                int matchLength = StringUtils.greatestCommonPrefix(userAgent, agent).length();
                if (matchLength <= longestMatch) continue;
                longestMatch = matchLength;
                bestMatch = sec;
            }
        }
        return bestMatch;
    }

    private String assureRelative(String path) {
        try {
            URI uri = new URI(path);
            if (uri.isAbsolute()) {
                URL url = uri.toURL();
                path = String.format("/%s%s%s", url.getPath(), url.getQuery() != null ? "?" + url.getQuery() : "", url.getRef() != null ? "#" + url.getRef() : "").replaceAll("/+", "/");
            }
            return path;
        }
        catch (Exception ex) {
            return path;
        }
    }

    private Access createDefaultAccess() {
        return new Access(this.defaultSection, "", "", true);
    }
}

