/*
 * Decompiled with CFR 0.152.
 */
package com.panforge.robotstxt;

import com.panforge.robotstxt.Access;
import com.panforge.robotstxt.Group;
import com.panforge.robotstxt.MatchingStrategy;
import com.panforge.robotstxt.RobotsTxt;
import com.panforge.robotstxt.RobotsTxtImpl;
import com.panforge.robotstxt.StringUtils;
import com.panforge.robotstxt.URLDecoder;
import com.panforge.robotstxt.WinningStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

class RobotsTxtReader {
    private final MatchingStrategy matchingStrategy;
    private final WinningStrategy winningStrategy;

    public RobotsTxtReader() {
        this(MatchingStrategy.DEFAULT, WinningStrategy.DEFAULT);
    }

    public RobotsTxtReader(MatchingStrategy matchingStrategy, WinningStrategy winningStrategy) {
        this.matchingStrategy = matchingStrategy;
        this.winningStrategy = winningStrategy;
    }

    public RobotsTxt readRobotsTxt(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        Group currentGroup = null;
        boolean startGroup = false;
        RobotsTxtImpl robots = new RobotsTxtImpl(this.matchingStrategy, this.winningStrategy);
        Entry entry = this.readEntry(reader);
        while (entry != null) {
            switch (entry.getKey().toUpperCase()) {
                case "USER-AGENT": {
                    if (!startGroup && currentGroup != null) {
                        robots.addGroup(currentGroup);
                        currentGroup = null;
                    }
                    if (currentGroup == null) {
                        currentGroup = new Group();
                    }
                    currentGroup.addUserAgent(entry.getValue());
                    startGroup = true;
                    break;
                }
                case "DISALLOW": {
                    if (currentGroup == null) break;
                    boolean access = entry.getValue().isEmpty();
                    currentGroup.addAccess(new Access(currentGroup, entry.getSource(), entry.getValue(), access));
                    startGroup = false;
                    break;
                }
                case "ALLOW": {
                    if (currentGroup == null) break;
                    boolean access = !entry.getValue().isEmpty();
                    currentGroup.addAccess(new Access(currentGroup, entry.getSource(), entry.getValue(), access));
                    startGroup = false;
                    break;
                }
                case "CRAWL-DELAY": {
                    if (currentGroup == null) break;
                    try {
                        int crawlDelay = Integer.parseInt(entry.getValue());
                        currentGroup.setCrawlDelay(crawlDelay);
                        startGroup = false;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "HOST": {
                    robots.setHost(entry.getValue());
                    startGroup = false;
                    break;
                }
                case "SITEMAP": {
                    robots.getSitemaps().add(entry.getValue());
                    startGroup = false;
                    break;
                }
                default: {
                    startGroup = false;
                }
            }
            entry = this.readEntry(reader);
        }
        if (currentGroup != null) {
            robots.addGroup(currentGroup);
        }
        return robots;
    }

    private Entry readEntry(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            Entry entry = this.parseEntry(line);
            if (entry != null) {
                return entry;
            }
            line = reader.readLine();
        }
        return null;
    }

    private Entry parseEntry(String line) throws IOException {
        if ((line = StringUtils.trimToEmpty(line)).startsWith("#")) {
            return null;
        }
        int colonIndex = line.indexOf(":");
        if (colonIndex < 0) {
            return null;
        }
        String key = StringUtils.trimToNull(line.substring(0, colonIndex));
        if (key == null) {
            return null;
        }
        String rest = line.substring(colonIndex + 1);
        int hashIndex = rest.indexOf("#");
        String value = StringUtils.trimToEmpty(hashIndex >= 0 ? rest.substring(0, hashIndex) : rest);
        value = URLDecoder.decode(value);
        return new Entry(line, key, value);
    }

    private static final class Entry {
        private final String source;
        private final String key;
        private final String value;

        public Entry(String source, String key, String value) {
            this.source = source;
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getSource() {
            return this.source;
        }

        public String toString() {
            return this.source;
        }
    }
}

