/*
 * Decompiled with CFR 0.152.
 */
package com.panforge.robotstxt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class TimeLimitedMatcherFactory {
    private static final long DEFAULT_TIMEOUT_MS = 2000L;
    private static final long timeoutMs = TimeLimitedMatcherFactory.determineTimeout();

    TimeLimitedMatcherFactory() {
    }

    public static Matcher matcher(Pattern pattern, CharSequence charSequence, long timeoutInMilliseconds) {
        if (!(charSequence instanceof TimeLimitedCharSequence)) {
            charSequence = new TimeLimitedCharSequence(charSequence, timeoutInMilliseconds, pattern, charSequence);
        }
        return pattern.matcher(charSequence);
    }

    public static Matcher matcher(Pattern pattern, CharSequence charSequence) {
        return TimeLimitedMatcherFactory.matcher(pattern, charSequence, timeoutMs);
    }

    private static Long determineTimeout() {
        String str = System.getProperty("com.panforge.robotstxt.timeout");
        if (str == null) {
            return 2000L;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return 2000L;
        }
    }

    private static class TimeLimitedCharSequence
    implements CharSequence {
        private final CharSequence inner;
        private final long timeoutInMilliseconds;
        private long timeoutAfterTimestamp = -1L;
        private final Pattern pattern;
        private final CharSequence originalCharSequence;

        public TimeLimitedCharSequence(CharSequence inner, long timeoutInMilliseconds, Pattern pattern, CharSequence originalCharSequence) {
            this.inner = inner;
            this.timeoutInMilliseconds = timeoutInMilliseconds;
            this.timeoutAfterTimestamp = System.currentTimeMillis() + timeoutInMilliseconds;
            this.pattern = pattern;
            this.originalCharSequence = originalCharSequence;
        }

        @Override
        public char charAt(int index) {
            if (System.currentTimeMillis() > this.timeoutAfterTimestamp) {
                throw new RegExpTimeoutException("Regular expression timeout after " + this.timeoutInMilliseconds + "ms for [ " + this.pattern.pattern() + " ] operating on [ " + this.originalCharSequence + " ]");
            }
            return this.inner.charAt(index);
        }

        @Override
        public int length() {
            return this.inner.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new TimeLimitedCharSequence(this.inner.subSequence(start, end), this.timeoutAfterTimestamp - System.currentTimeMillis(), this.pattern, this.originalCharSequence);
        }

        @Override
        public String toString() {
            return this.inner.toString();
        }
    }

    public static class RegExpTimeoutException
    extends RuntimeException {
        public RegExpTimeoutException(String message) {
            super(message);
        }
    }
}

