/*
 * Decompiled with CFR 0.152.
 */
package com.pangility.schwab.api.client.accountsandtrading;

import com.pangility.schwab.api.client.accountsandtrading.AccountNotFoundException;
import com.pangility.schwab.api.client.accountsandtrading.OrderNotFoundException;
import com.pangility.schwab.api.client.accountsandtrading.TransactionNotFoundException;
import com.pangility.schwab.api.client.accountsandtrading.model.account.Account;
import com.pangility.schwab.api.client.accountsandtrading.model.encryptedaccounts.EncryptedAccount;
import com.pangility.schwab.api.client.accountsandtrading.model.order.Order;
import com.pangility.schwab.api.client.accountsandtrading.model.order.OrderRequest;
import com.pangility.schwab.api.client.accountsandtrading.model.transaction.Transaction;
import com.pangility.schwab.api.client.accountsandtrading.model.transaction.TransactionRequest;
import com.pangility.schwab.api.client.accountsandtrading.model.userpreference.UserPreferenceResponse;
import com.pangility.schwab.api.client.common.SchwabBaseApiClient;
import java.time.format.DateTimeFormatter;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
@ConditionalOnResource(resources={"classpath:schwabapiclient.properties"})
public class SchwabAccountsAndTradingApiClient
extends SchwabBaseApiClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchwabAccountsAndTradingApiClient.class);
    @Value(value="${schwab-api.traderPath}")
    private String schwabTraderPath;

    @Deprecated
    public List<EncryptedAccount> fetchEncryptedAccounts(@NonNull String schwabUserId) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        return this.fetchEncryptedAccountsToFlux(schwabUserId).toStream().toList();
    }

    public Flux<EncryptedAccount> fetchEncryptedAccountsToFlux(@NonNull String schwabUserId) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        log.info("Fetch Encrypted Accounts");
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"accounts", "accountNumbers"});
        return this.callGetApiToFlux(schwabUserId, uriBuilder, EncryptedAccount.class);
    }

    @Deprecated
    public Account fetchAccount(@NonNull String schwabUserId, @NonNull String encryptedAccount) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (encryptedAccount == null) {
            throw new NullPointerException("encryptedAccount is marked non-null but is null");
        }
        return this.fetchAccount(schwabUserId, encryptedAccount, null);
    }

    @Deprecated
    public Account fetchAccount(@NonNull String schwabUserId, @NonNull String encryptedAccount, String fields) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (encryptedAccount == null) {
            throw new NullPointerException("encryptedAccount is marked non-null but is null");
        }
        return (Account)this.fetchAccountToMono(schwabUserId, encryptedAccount, fields).block();
    }

    public Mono<Account> fetchAccountToMono(@NonNull String schwabUserId, @NonNull String encryptedAccount) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (encryptedAccount == null) {
            throw new NullPointerException("encryptedAccount is marked non-null but is null");
        }
        return this.fetchAccountToMono(schwabUserId, encryptedAccount, null);
    }

    public Mono<Account> fetchAccountToMono(@NonNull String schwabUserId, @NonNull String encryptedAccount, String fields) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (encryptedAccount == null) {
            throw new NullPointerException("encryptedAccount is marked non-null but is null");
        }
        log.info("Fetch Account [{}] {}", (Object)encryptedAccount, (Object)(fields != null && fields.equalsIgnoreCase("positions") ? "with positions" : ""));
        if (encryptedAccount.isEmpty()) {
            return Mono.error((Throwable)new IllegalArgumentException("Encrypted Account must not be empty"));
        }
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"accounts", encryptedAccount});
        if (fields != null) {
            uriBuilder.queryParam("fields", new Object[]{fields});
        }
        return this.callGetApiToMono(schwabUserId, uriBuilder, Account.class).onErrorResume(throwable -> {
            if (throwable instanceof WebClientResponseException && ((WebClientResponseException)throwable).getStatusCode().isSameCodeAs((HttpStatusCode)HttpStatus.NOT_FOUND)) {
                return Mono.error((Throwable)new AccountNotFoundException("Encrypted Account '" + encryptedAccount + "' not found"));
            }
            return Mono.error((Throwable)throwable);
        }).flatMap(accountResponse -> {
            if (accountResponse.getSecuritiesAccount().getAccountNumber() != null && !accountResponse.getSecuritiesAccount().getAccountNumber().isEmpty()) {
                return Mono.just((Object)accountResponse);
            }
            return Mono.error((Throwable)new AccountNotFoundException("Encrypted Account '" + encryptedAccount + "' not found"));
        });
    }

    @Deprecated
    public List<Account> fetchAccounts(@NonNull String schwabUserId) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        return this.fetchAccounts(schwabUserId, null);
    }

    @Deprecated
    public List<Account> fetchAccounts(@NonNull String schwabUserId, String fields) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        return this.fetchAccountsToFlux(schwabUserId, fields).toStream().toList();
    }

    public Flux<Account> fetchAccountsToFlux(@NonNull String schwabUserId) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        return this.fetchAccountsToFlux(schwabUserId, null);
    }

    public Flux<Account> fetchAccountsToFlux(@NonNull String schwabUserId, String fields) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        log.info("Fetch All Accounts {}", (Object)(fields != null && fields.equalsIgnoreCase("positions") ? "with positions" : ""));
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"accounts"});
        if (fields != null) {
            uriBuilder.queryParam("fields", new Object[]{fields});
        }
        return this.callGetApiToFlux(schwabUserId, uriBuilder, Account.class);
    }

    @Deprecated
    public Order fetchOrder(@NonNull String schwabUserId, @NonNull String encryptedAccount, @NonNull Long orderId) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (encryptedAccount == null) {
            throw new NullPointerException("encryptedAccount is marked non-null but is null");
        }
        if (orderId == null) {
            throw new NullPointerException("orderId is marked non-null but is null");
        }
        return (Order)this.fetchOrderToMono(schwabUserId, encryptedAccount, orderId).block();
    }

    public Mono<Order> fetchOrderToMono(@NonNull String schwabUserId, @NonNull String encryptedAccount, @NonNull Long orderId) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (encryptedAccount == null) {
            throw new NullPointerException("encryptedAccount is marked non-null but is null");
        }
        if (orderId == null) {
            throw new NullPointerException("orderId is marked non-null but is null");
        }
        log.info("Fetch Order [{}] for Encrypted Account [{}]", (Object)orderId, (Object)encryptedAccount);
        if (encryptedAccount.isEmpty() || orderId <= 0L) {
            return Mono.error((Throwable)new IllegalArgumentException("Account Number and Order ID are required"));
        }
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"accounts", encryptedAccount, "orders", orderId.toString()});
        return this.callGetApiToMono(schwabUserId, uriBuilder, Order.class).onErrorResume(throwable -> {
            if (throwable instanceof WebClientResponseException && ((WebClientResponseException)throwable).getStatusCode().isSameCodeAs((HttpStatusCode)HttpStatus.NOT_FOUND)) {
                return Mono.error((Throwable)new OrderNotFoundException("Order [" + orderId + "] on Encrypted Account [" + encryptedAccount + "] not found"));
            }
            return Mono.error((Throwable)throwable);
        }).flatMap(orderResponse -> {
            if (orderResponse.getAccountNumber() > 0L && orderResponse.getOrderId().equals(orderId)) {
                return Mono.just((Object)orderResponse);
            }
            return Mono.error((Throwable)new OrderNotFoundException("Order [" + orderId + "] on Encrypted Account [" + encryptedAccount + "] not found"));
        });
    }

    @Deprecated
    public List<Order> fetchOrders(@NonNull String schwabUserId, @NonNull OrderRequest orderRequest) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (orderRequest == null) {
            throw new NullPointerException("orderRequest is marked non-null but is null");
        }
        return this.fetchOrders(schwabUserId, null, orderRequest);
    }

    @Deprecated
    public List<Order> fetchOrders(@NonNull String schwabUserId, String encryptedAccount, @NonNull OrderRequest orderRequest) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (orderRequest == null) {
            throw new NullPointerException("orderRequest is marked non-null but is null");
        }
        return this.fetchOrdersToFlux(schwabUserId, encryptedAccount, orderRequest).toStream().toList();
    }

    public Flux<Order> fetchOrdersToFlux(@NonNull String schwabUserId, @NonNull OrderRequest orderRequest) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (orderRequest == null) {
            throw new NullPointerException("orderRequest is marked non-null but is null");
        }
        return this.fetchOrdersToFlux(schwabUserId, null, orderRequest);
    }

    public Flux<Order> fetchOrdersToFlux(@NonNull String schwabUserId, String encryptedAccount, @NonNull OrderRequest orderRequest) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (orderRequest == null) {
            throw new NullPointerException("orderRequest is marked non-null but is null");
        }
        log.info("Fetch Orders for Account [{}] -> {}", (Object)(encryptedAccount == null ? "all accounts" : encryptedAccount), (Object)orderRequest);
        if (orderRequest.getFromEnteredTime() == null || orderRequest.getToEnteredTime() == null) {
            return Flux.error((Throwable)new IllegalArgumentException("Both From and To Entered date/times are required"));
        }
        UriComponentsBuilder uriBuilder = this.getUriBuilder();
        if (encryptedAccount != null) {
            uriBuilder.pathSegment(new String[]{"accounts", encryptedAccount});
        }
        uriBuilder.pathSegment(new String[]{"orders"}).queryParam("fromEnteredTime", new Object[]{orderRequest.getFromEnteredTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZZZZZ"))}).queryParam("toEnteredTime", new Object[]{orderRequest.getToEnteredTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZZZZZ"))});
        if (orderRequest.getMaxResults() != null) {
            uriBuilder.queryParam("maxResults", new Object[]{orderRequest.getMaxResults()});
        }
        if (orderRequest.getStatus() != null) {
            uriBuilder.queryParam("status", new Object[]{orderRequest.getStatus()});
        }
        return this.callGetApiToFlux(schwabUserId, uriBuilder, Order.class);
    }

    @Deprecated
    public Transaction fetchTransaction(@NonNull String schwabUserId, @NonNull String encryptedAccount, @NonNull Long activityId) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (encryptedAccount == null) {
            throw new NullPointerException("encryptedAccount is marked non-null but is null");
        }
        if (activityId == null) {
            throw new NullPointerException("activityId is marked non-null but is null");
        }
        return (Transaction)this.fetchTransactionToMono(schwabUserId, encryptedAccount, activityId).block();
    }

    public Mono<Transaction> fetchTransactionToMono(@NonNull String schwabUserId, @NonNull String encryptedAccount, @NonNull Long activityId) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (encryptedAccount == null) {
            throw new NullPointerException("encryptedAccount is marked non-null but is null");
        }
        if (activityId == null) {
            throw new NullPointerException("activityId is marked non-null but is null");
        }
        log.info("Fetch Transaction [{}] for Account [{}]", (Object)activityId, (Object)encryptedAccount);
        if (encryptedAccount.isEmpty()) {
            return Mono.error((Throwable)new IllegalArgumentException("Encrypted Account is required"));
        }
        if (activityId <= 0L) {
            return Mono.error((Throwable)new IllegalArgumentException("Activity ID is required"));
        }
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"accounts", encryptedAccount, "transactions", activityId.toString()});
        return this.callGetApiToMono(schwabUserId, uriBuilder, Transaction.class).onErrorResume(throwable -> {
            if (throwable instanceof WebClientResponseException && ((WebClientResponseException)throwable).getStatusCode().isSameCodeAs((HttpStatusCode)HttpStatus.NOT_FOUND)) {
                return Mono.error((Throwable)new TransactionNotFoundException("Transaction [" + activityId + "] on Encrypted Account [" + encryptedAccount + "] not found"));
            }
            return Mono.error((Throwable)throwable);
        }).flatMap(transactionResponse -> {
            if (transactionResponse.getAccountNumber() != null && !transactionResponse.getAccountNumber().isEmpty()) {
                return Mono.just((Object)transactionResponse);
            }
            return Mono.error((Throwable)new TransactionNotFoundException("Transaction [" + activityId + "] on Encrypted Account [" + encryptedAccount + "] not found"));
        });
    }

    @Deprecated
    public List<Transaction> fetchTransactions(@NonNull String schwabUserId, @NonNull String encryptedAccount, @NonNull TransactionRequest transactionRequest) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (encryptedAccount == null) {
            throw new NullPointerException("encryptedAccount is marked non-null but is null");
        }
        if (transactionRequest == null) {
            throw new NullPointerException("transactionRequest is marked non-null but is null");
        }
        return this.fetchTransactionsToFlux(schwabUserId, encryptedAccount, transactionRequest).toStream().toList();
    }

    public Flux<Transaction> fetchTransactionsToFlux(@NonNull String schwabUserId, @NonNull String encryptedAccount, @NonNull TransactionRequest transactionRequest) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (encryptedAccount == null) {
            throw new NullPointerException("encryptedAccount is marked non-null but is null");
        }
        if (transactionRequest == null) {
            throw new NullPointerException("transactionRequest is marked non-null but is null");
        }
        log.info("Fetch Transactions for Account [{}] -> {}", (Object)encryptedAccount, (Object)transactionRequest);
        if (encryptedAccount.isEmpty()) {
            return Flux.error((Throwable)new IllegalArgumentException("Encrypted Account is required"));
        }
        if (transactionRequest.getStartDate() == null || transactionRequest.getEndDate() == null) {
            return Flux.error((Throwable)new IllegalArgumentException("Both Start and End date/times are required"));
        }
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"accounts", encryptedAccount, "transactions"}).queryParam("startDate", new Object[]{transactionRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZZZZZ"))}).queryParam("endDate", new Object[]{transactionRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZZZZZ"))});
        if (transactionRequest.getSymbol() != null) {
            uriBuilder.queryParam("symbol", new Object[]{transactionRequest.getSymbol()});
        }
        if (transactionRequest.getTypes() != null) {
            uriBuilder.queryParam("types", new Object[]{transactionRequest.getTypes()});
        }
        return this.callGetApiToFlux(schwabUserId, uriBuilder, Transaction.class).onErrorResume(throwable -> {
            if (throwable instanceof WebClientResponseException && ((WebClientResponseException)throwable).getStatusCode().isSameCodeAs((HttpStatusCode)HttpStatus.NOT_FOUND)) {
                return Flux.error((Throwable)new TransactionNotFoundException("Transactions on Encrypted Account [" + encryptedAccount + "] not found"));
            }
            return Flux.error((Throwable)throwable);
        });
    }

    @Deprecated
    public UserPreferenceResponse fetchUserPreference(@NonNull String schwabUserId) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        return (UserPreferenceResponse)this.fetchUserPreferenceToMono(schwabUserId).block();
    }

    public Mono<UserPreferenceResponse> fetchUserPreferenceToMono(@NonNull String schwabUserId) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        log.info("Fetch User Preference");
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"userPreference"});
        return this.callGetApiToMono(schwabUserId, uriBuilder, UserPreferenceResponse.class);
    }

    public Mono<String> placeOrder(@NonNull String schwabUserId, @NonNull String encryptedAccount, @NonNull Order order) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (encryptedAccount == null) {
            throw new NullPointerException("encryptedAccount is marked non-null but is null");
        }
        if (order == null) {
            throw new NullPointerException("order is marked non-null but is null");
        }
        log.info("Place Order on Account [{}] -> {}", (Object)encryptedAccount, (Object)order);
        if (encryptedAccount.isEmpty()) {
            return Mono.error((Throwable)new IllegalArgumentException("Encrypted account number is required"));
        }
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"accounts", encryptedAccount, "orders"});
        return this.callPostApiToMono(schwabUserId, uriBuilder, (Object)order, String.class);
    }

    public Mono<String> replaceOrder(@NonNull String schwabUserId, @NonNull String encryptedAccount, @NonNull Long orderId, @NonNull Order order) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (encryptedAccount == null) {
            throw new NullPointerException("encryptedAccount is marked non-null but is null");
        }
        if (orderId == null) {
            throw new NullPointerException("orderId is marked non-null but is null");
        }
        if (order == null) {
            throw new NullPointerException("order is marked non-null but is null");
        }
        log.info("Replace Order [{}] on Account [{}] -> {}", new Object[]{orderId, encryptedAccount, order});
        if (encryptedAccount.isEmpty()) {
            return Mono.error((Throwable)new IllegalArgumentException("Encrypted account number is required"));
        }
        if (orderId <= 0L) {
            return Mono.error((Throwable)new IllegalArgumentException("Order ID is required"));
        }
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"accounts", encryptedAccount, "orders", orderId.toString()});
        return this.callPutApiToMono(schwabUserId, uriBuilder, (Object)order, String.class);
    }

    public Mono<String> cancelOrder(@NonNull String schwabUserId, @NonNull String encryptedAccount, @NonNull Long orderId) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (encryptedAccount == null) {
            throw new NullPointerException("encryptedAccount is marked non-null but is null");
        }
        if (orderId == null) {
            throw new NullPointerException("orderId is marked non-null but is null");
        }
        log.info("Cancel Order [{}] on Account [{}]", (Object)orderId, (Object)encryptedAccount);
        if (encryptedAccount.isEmpty()) {
            return Mono.error((Throwable)new IllegalArgumentException("Encrypted account number is required"));
        }
        if (orderId <= 0L) {
            return Mono.error((Throwable)new IllegalArgumentException("Order Id is required"));
        }
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"accounts", encryptedAccount, "orders", orderId.toString()});
        return this.callDeleteApiToMono(schwabUserId, uriBuilder, null, String.class);
    }

    private UriComponentsBuilder getUriBuilder() {
        return UriComponentsBuilder.newInstance().pathSegment(new String[]{this.schwabTraderPath, this.schwabApiVersion});
    }
}

