/*
 * Decompiled with CFR 0.152.
 */
package com.pangility.schwab.api.client.common;

import com.pangility.schwab.api.client.common.ApiUnauthorizedException;
import com.pangility.schwab.api.client.common.SchwabWebClient;
import com.pangility.schwab.api.client.common.deserializers.ApiTooManyRequestsException;
import com.pangility.schwab.api.client.oauth2.SchwabAccount;
import com.pangility.schwab.api.client.oauth2.SchwabOauth2Controller;
import com.pangility.schwab.api.client.oauth2.SchwabTokenHandler;
import java.lang.reflect.Type;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class SchwabBaseApiClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchwabBaseApiClient.class);
    @Value(value="${schwab-api.targetUrl}")
    private String schwabTargetUrl;
    @Value(value="${schwab-api.apiVersion}")
    protected String schwabApiVersion;
    @Autowired
    private SchwabOauth2Controller schwabOauth2Controller;
    @Autowired
    private SchwabWebClient schwabWebClient;

    public void init(@NonNull SchwabAccount schwabAccount) {
        if (schwabAccount == null) {
            throw new NullPointerException("schwabAccount is marked non-null but is null");
        }
        this.init(Collections.singletonList(schwabAccount), null);
    }

    public void init(@NonNull SchwabAccount schwabAccount, SchwabTokenHandler tokenHandler) {
        if (schwabAccount == null) {
            throw new NullPointerException("schwabAccount is marked non-null but is null");
        }
        this.init(Collections.singletonList(schwabAccount), tokenHandler);
    }

    public void init(@NonNull List<SchwabAccount> schwabAccounts) {
        if (schwabAccounts == null) {
            throw new NullPointerException("schwabAccounts is marked non-null but is null");
        }
        this.init(schwabAccounts, null);
    }

    public void init(@NonNull List<SchwabAccount> schwabAccounts, SchwabTokenHandler tokenHandler) {
        if (schwabAccounts == null) {
            throw new NullPointerException("schwabAccounts is marked non-null but is null");
        }
        this.schwabOauth2Controller.init(schwabAccounts, tokenHandler);
    }

    public Boolean isInitialized() {
        return this.schwabOauth2Controller.isInitialized();
    }

    @Deprecated
    protected <T> List<T> callGetApiAsList(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, @NonNull ParameterizedTypeReference<List<T>> bodyTypeReference) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (bodyTypeReference == null) {
            throw new NullPointerException("bodyTypeReference is marked non-null but is null");
        }
        List ret = null;
        ResponseEntity retMono = (ResponseEntity)this.callApi(schwabUserId, HttpMethod.GET, uriComponentsBuilder).toEntity(bodyTypeReference).block();
        if (retMono != null && retMono.hasBody()) {
            ret = (List)retMono.getBody();
        }
        return ret;
    }

    @Deprecated
    protected <T> Map<String, T> callGetApiAsMap(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, @NonNull ParameterizedTypeReference<Map<String, T>> bodyTypeReference) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (bodyTypeReference == null) {
            throw new NullPointerException("bodyTypeReference is marked non-null but is null");
        }
        Map ret = null;
        ResponseEntity retMono = (ResponseEntity)this.callApi(schwabUserId, HttpMethod.GET, uriComponentsBuilder).toEntity(bodyTypeReference).block();
        if (retMono != null && retMono.hasBody()) {
            ret = (Map)retMono.getBody();
        }
        return ret;
    }

    protected <T> Mono<T> callGetApiToMono(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, @NonNull Class<T> clazz) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.callApiToMono(schwabUserId, HttpMethod.GET, uriComponentsBuilder, null, clazz);
    }

    protected <T> Mono<T> callGetApiToMono(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, @NonNull ParameterizedTypeReference<T> bodyTypeReference) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (bodyTypeReference == null) {
            throw new NullPointerException("bodyTypeReference is marked non-null but is null");
        }
        return this.callApiToMono(schwabUserId, HttpMethod.GET, uriComponentsBuilder, null, bodyTypeReference);
    }

    protected <T> Flux<T> callGetApiToFlux(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, @NonNull Class<T> clazz) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.callApiToFlux(schwabUserId, HttpMethod.GET, uriComponentsBuilder, null, clazz);
    }

    protected <T> Flux<T> callGetApiToFlux(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, @NonNull ParameterizedTypeReference<T> bodyTypeReference) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (bodyTypeReference == null) {
            throw new NullPointerException("bodyTypeReference is marked non-null but is null");
        }
        return this.callApiToFlux(schwabUserId, HttpMethod.GET, uriComponentsBuilder, null, bodyTypeReference);
    }

    @Deprecated
    protected <T> T callGetApi(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, @NonNull Class<T> clazz) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.callApi(schwabUserId, HttpMethod.GET, uriComponentsBuilder, clazz, null);
    }

    protected void callPostApi(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        this.callApiToMono(schwabUserId, HttpMethod.POST, uriComponentsBuilder, null, Object.class);
    }

    protected void callPostApi(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        this.callApiToMono(schwabUserId, HttpMethod.POST, uriComponentsBuilder, body, Object.class);
    }

    @Deprecated
    protected <T> T callPostApi(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull Class<T> clazz) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.callApi(schwabUserId, HttpMethod.POST, uriComponentsBuilder, clazz, body);
    }

    protected <T> Mono<T> callPostApiToMono(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, @NonNull Class<T> clazz) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.callApiToMono(schwabUserId, HttpMethod.POST, uriComponentsBuilder, null, clazz);
    }

    protected <T> Mono<T> callPostApiToMono(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull Class<T> clazz) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.callApiToMono(schwabUserId, HttpMethod.POST, uriComponentsBuilder, body, clazz);
    }

    protected <T> Mono<T> callPostApiToMono(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull ParameterizedTypeReference<T> bodyTypeReference) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (bodyTypeReference == null) {
            throw new NullPointerException("bodyTypeReference is marked non-null but is null");
        }
        return this.callApiToMono(schwabUserId, HttpMethod.POST, uriComponentsBuilder, body, bodyTypeReference);
    }

    protected <T> Flux<T> callPostApiToFlux(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull Class<T> clazz) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.callApiToFlux(schwabUserId, HttpMethod.POST, uriComponentsBuilder, body, clazz);
    }

    protected <T> Flux<T> callPostApiToFlux(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull ParameterizedTypeReference<T> bodyTypeReference) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (bodyTypeReference == null) {
            throw new NullPointerException("bodyTypeReference is marked non-null but is null");
        }
        return this.callApiToFlux(schwabUserId, HttpMethod.POST, uriComponentsBuilder, body, bodyTypeReference);
    }

    protected void callPutApi(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        this.callApiToMono(schwabUserId, HttpMethod.PUT, uriComponentsBuilder, null, Object.class);
    }

    protected void callPutApi(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        this.callApiToMono(schwabUserId, HttpMethod.PUT, uriComponentsBuilder, body, Object.class);
    }

    @Deprecated
    protected <T> T callPutApi(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, @NonNull Class<T> clazz, Object body) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.callApi(schwabUserId, HttpMethod.PUT, uriComponentsBuilder, clazz, body);
    }

    protected <T> Mono<T> callPutApiToMono(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull Class<T> clazz) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.callApiToMono(schwabUserId, HttpMethod.PUT, uriComponentsBuilder, body, clazz);
    }

    protected <T> Mono<T> callPutApiToMono(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull ParameterizedTypeReference<T> bodyTypeReference) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (bodyTypeReference == null) {
            throw new NullPointerException("bodyTypeReference is marked non-null but is null");
        }
        return this.callApiToMono(schwabUserId, HttpMethod.PUT, uriComponentsBuilder, body, bodyTypeReference);
    }

    protected <T> Flux<T> callPutApiToFlux(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull Class<T> clazz) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.callApiToFlux(schwabUserId, HttpMethod.PUT, uriComponentsBuilder, body, clazz);
    }

    protected <T> Flux<T> callPutApiToFlux(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull ParameterizedTypeReference<T> bodyTypeReference) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (bodyTypeReference == null) {
            throw new NullPointerException("bodyTypeReference is marked non-null but is null");
        }
        return this.callApiToFlux(schwabUserId, HttpMethod.PUT, uriComponentsBuilder, body, bodyTypeReference);
    }

    protected void callDeleteApi(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        this.callApiToMono(schwabUserId, HttpMethod.DELETE, uriComponentsBuilder, null, Object.class);
    }

    protected void callDeleteApi(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        this.callApiToMono(schwabUserId, HttpMethod.DELETE, uriComponentsBuilder, body, Object.class);
    }

    @Deprecated
    protected <T> T callDeleteApi(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, @NonNull Class<T> clazz, Object body) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.callApi(schwabUserId, HttpMethod.DELETE, uriComponentsBuilder, clazz, body);
    }

    @Deprecated
    protected <T> T callApi(@NonNull String schwabUserId, @NonNull HttpMethod httpMethod, @NonNull UriComponentsBuilder uriComponentsBuilder, @NonNull Class<T> clazz, Object body) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Object ret = null;
        WebClient.ResponseSpec responseSpec = this.callApi(schwabUserId, HttpMethod.POST, uriComponentsBuilder, body);
        ResponseEntity retEntity = (ResponseEntity)responseSpec.toEntity(clazz).block();
        if (retEntity != null && retEntity.hasBody()) {
            ret = retEntity.getBody();
        }
        return (T)ret;
    }

    protected <T> Mono<T> callDeleteApiToMono(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull Class<T> clazz) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.callApiToMono(schwabUserId, HttpMethod.DELETE, uriComponentsBuilder, body, clazz);
    }

    protected <T> Mono<T> callDeleteApiToMono(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull ParameterizedTypeReference<T> bodyTypeReference) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (bodyTypeReference == null) {
            throw new NullPointerException("bodyTypeReference is marked non-null but is null");
        }
        return this.callApiToMono(schwabUserId, HttpMethod.DELETE, uriComponentsBuilder, body, bodyTypeReference);
    }

    protected <T> Flux<T> callDeleteApiToFlux(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull Class<T> clazz) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.callApiToFlux(schwabUserId, HttpMethod.DELETE, uriComponentsBuilder, body, clazz);
    }

    protected <T> Flux<T> callDeleteApiToFlux(@NonNull String schwabUserId, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull ParameterizedTypeReference<T> bodyTypeReference) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (bodyTypeReference == null) {
            throw new NullPointerException("bodyTypeReference is marked non-null but is null");
        }
        return this.callApiToFlux(schwabUserId, HttpMethod.DELETE, uriComponentsBuilder, body, bodyTypeReference);
    }

    @Deprecated
    private WebClient.ResponseSpec callApi(@NonNull String schwabUserId, @NonNull HttpMethod httpMethod, @NonNull UriComponentsBuilder uriComponentsBuilder) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        return this.callApi(schwabUserId, httpMethod, uriComponentsBuilder, null);
    }

    @Deprecated
    private WebClient.ResponseSpec callApi(@NonNull String schwabUserId, @NonNull HttpMethod httpMethod, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        return (WebClient.ResponseSpec)this.schwabOauth2Controller.getAccessToken(schwabUserId).map(tokenInfo -> {
            this.schwabOauth2Controller.validateRefreshToken((SchwabAccount)tokenInfo);
            URI uri = uriComponentsBuilder.scheme("https").host(this.schwabTargetUrl).build().toUri();
            WebClient.RequestBodySpec bodySpec = (WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.schwabWebClient.getSchwabWebClient().method(httpMethod).uri(uri)).headers(h -> h.setBearerAuth(tokenInfo.getAccessToken()));
            if (body != null) {
                bodySpec.body(BodyInserters.fromValue((Object)body));
            }
            return bodySpec.retrieve().onStatus(httpStatus -> httpStatus.isSameCodeAs((HttpStatusCode)HttpStatus.UNAUTHORIZED), error -> Mono.error((Throwable)new ApiUnauthorizedException()));
        }).block();
    }

    private <T> Mono<T> callApiToMono(@NonNull String schwabUserId, @NonNull HttpMethod httpMethod, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull Class<T> clazz) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.callApiToMono(schwabUserId, httpMethod, uriComponentsBuilder, body, this.classToTypeReference(clazz), false);
    }

    private <T> Mono<T> callApiToMono(@NonNull String schwabUserId, @NonNull HttpMethod httpMethod, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull ParameterizedTypeReference<T> bodyTypeReference) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (bodyTypeReference == null) {
            throw new NullPointerException("bodyTypeReference is marked non-null but is null");
        }
        return this.callApiToMono(schwabUserId, httpMethod, uriComponentsBuilder, body, bodyTypeReference, false);
    }

    private <T> Mono<T> callApiToMono(@NonNull String schwabUserId, @NonNull HttpMethod httpMethod, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull ParameterizedTypeReference<T> bodyTypeReference, @NonNull Boolean hasRetried401WithNewAccessToken) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (bodyTypeReference == null) {
            throw new NullPointerException("bodyTypeReference is marked non-null but is null");
        }
        if (hasRetried401WithNewAccessToken == null) {
            throw new NullPointerException("hasRetried401WithNewAccessToken is marked non-null but is null");
        }
        return this.schwabOauth2Controller.getAccessToken(schwabUserId).flatMap(tokenInfo -> this.callApiPreProcessToMono(schwabUserId, httpMethod, uriComponentsBuilder, body, (SchwabAccount)tokenInfo).flatMap(requestBodySpec -> requestBodySpec.exchangeToMono(response -> {
            Mono mono = response.statusCode().is2xxSuccessful() ? response.bodyToMono(bodyTypeReference) : (response.statusCode().is4xxClientError() || response.statusCode().is5xxServerError() ? (response.statusCode().isSameCodeAs((HttpStatusCode)HttpStatus.UNAUTHORIZED) ? Mono.error((Throwable)new ApiUnauthorizedException()) : (response.statusCode().isSameCodeAs((HttpStatusCode)HttpStatus.TOO_MANY_REQUESTS) ? Mono.error((Throwable)new ApiTooManyRequestsException()) : response.createException().flatMap(Mono::error))) : response.createException().flatMap(Mono::error));
            return mono;
        })).retryWhen((Retry)Retry.backoff((long)10L, (Duration)Duration.ofSeconds(1L)).jitter(0.25).filter(throwable -> throwable instanceof ApiTooManyRequestsException)).onErrorResume(throwable -> {
            if (throwable instanceof ApiUnauthorizedException && !hasRetried401WithNewAccessToken.booleanValue()) {
                this.schwabOauth2Controller.getSchwabAccount(schwabUserId).setAccessToken(null);
                return this.callApiToMono(schwabUserId, httpMethod, uriComponentsBuilder, body, bodyTypeReference, true);
            }
            return Mono.error((Throwable)throwable);
        }));
    }

    private <T> Flux<T> callApiToFlux(@NonNull String schwabUserId, @NonNull HttpMethod httpMethod, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull Class<T> clazz) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.callApiToFlux(schwabUserId, httpMethod, uriComponentsBuilder, body, this.classToTypeReference(clazz));
    }

    private <T> Flux<T> callApiToFlux(@NonNull String schwabUserId, @NonNull HttpMethod httpMethod, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull ParameterizedTypeReference<T> bodyTypeReference) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (bodyTypeReference == null) {
            throw new NullPointerException("bodyTypeReference is marked non-null but is null");
        }
        return this.callApiToFlux(schwabUserId, httpMethod, uriComponentsBuilder, body, bodyTypeReference, false);
    }

    private <T> Flux<T> callApiToFlux(@NonNull String schwabUserId, @NonNull HttpMethod httpMethod, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull ParameterizedTypeReference<T> bodyTypeReference, @NonNull Boolean hasRetried401WithNewAccessToken) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (bodyTypeReference == null) {
            throw new NullPointerException("bodyTypeReference is marked non-null but is null");
        }
        if (hasRetried401WithNewAccessToken == null) {
            throw new NullPointerException("hasRetried401WithNewAccessToken is marked non-null but is null");
        }
        return this.schwabOauth2Controller.getAccessToken(schwabUserId).flatMapMany(tokenInfo -> this.callApiPreProcessToMono(schwabUserId, httpMethod, uriComponentsBuilder, body, (SchwabAccount)tokenInfo).flatMapMany(requestBodySpec -> requestBodySpec.exchangeToFlux(response -> {
            Flux flux = response.statusCode().equals(HttpStatus.OK) ? response.bodyToFlux(bodyTypeReference) : (response.statusCode().is4xxClientError() || response.statusCode().is5xxServerError() ? (response.statusCode().isSameCodeAs((HttpStatusCode)HttpStatus.UNAUTHORIZED) ? Flux.error((Throwable)new ApiUnauthorizedException()) : (response.statusCode().isSameCodeAs((HttpStatusCode)HttpStatus.TOO_MANY_REQUESTS) ? Flux.error((Throwable)new ApiTooManyRequestsException()) : response.createException().flatMapMany(Flux::error))) : response.createException().flatMapMany(Flux::error));
            return flux;
        })).retryWhen((Retry)Retry.backoff((long)10L, (Duration)Duration.ofSeconds(1L)).jitter(0.25).filter(throwable -> throwable instanceof ApiTooManyRequestsException)).onErrorResume(throwable -> {
            if (throwable instanceof ApiUnauthorizedException && !hasRetried401WithNewAccessToken.booleanValue()) {
                this.schwabOauth2Controller.getSchwabAccount(schwabUserId).setAccessToken(null);
                return this.callApiToFlux(schwabUserId, httpMethod, uriComponentsBuilder, body, bodyTypeReference, true);
            }
            return Flux.error((Throwable)throwable);
        }));
    }

    private WebClient.RequestBodySpec callApiPreProcess(@NonNull String schwabUserId, @NonNull HttpMethod httpMethod, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull SchwabAccount tokenInfo) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (tokenInfo == null) {
            throw new NullPointerException("tokenInfo is marked non-null but is null");
        }
        return (WebClient.RequestBodySpec)this.callApiPreProcessToMono(schwabUserId, httpMethod, uriComponentsBuilder, body, tokenInfo).block();
    }

    private Mono<WebClient.RequestBodySpec> callApiPreProcessToMono(@NonNull String schwabUserId, @NonNull HttpMethod httpMethod, @NonNull UriComponentsBuilder uriComponentsBuilder, Object body, @NonNull SchwabAccount tokenInfo) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (uriComponentsBuilder == null) {
            throw new NullPointerException("uriComponentsBuilder is marked non-null but is null");
        }
        if (tokenInfo == null) {
            throw new NullPointerException("tokenInfo is marked non-null but is null");
        }
        return this.schwabOauth2Controller.validateRefreshTokenToMono(tokenInfo).flatMap(schwabAccount -> {
            URI uri = uriComponentsBuilder.scheme("https").host(this.schwabTargetUrl).build().toUri();
            WebClient.RequestBodySpec bodySpec = (WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.schwabWebClient.getSchwabWebClient().method(httpMethod).uri(uri)).headers(h -> h.setBearerAuth(tokenInfo.getAccessToken()));
            if (body != null) {
                bodySpec.body(BodyInserters.fromValue((Object)body));
            }
            return Mono.just((Object)bodySpec);
        });
    }

    private <T> ParameterizedTypeReference<T> classToTypeReference(final Class<T> clazz) {
        return new ParameterizedTypeReference<T>(){

            @NonNull
            public Type getType() {
                return clazz;
            }
        };
    }
}

