/*
 * Decompiled with CFR 0.152.
 */
package com.pangility.schwab.api.client.common;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.pangility.schwab.api.client.common.OnApiEnabledCondition;
import com.pangility.schwab.api.client.common.deserializers.BigDecimalNanDeserializer;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import lombok.NonNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.codec.Decoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpRequestDecorator;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.stereotype.Component;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Component
@Conditional(value={OnApiEnabledCondition.class})
public class SchwabWebClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchwabWebClient.class);
    @Value(value="${schwab-api.targetUrl}")
    private String schwabTargetUrl;

    public WebClient getSchwabWebClient() {
        URI schwabUri = UriComponentsBuilder.newInstance().scheme("https").host(this.schwabTargetUrl).build().toUri();
        int size = 0x1000000;
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new SimpleModule().addDeserializer(BigDecimal.class, (JsonDeserializer)new BigDecimalNanDeserializer()));
        ExchangeStrategies strategies = ExchangeStrategies.builder().codecs(codecs -> {
            codecs.defaultCodecs().maxInMemorySize(0x1000000);
            codecs.defaultCodecs().jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(objectMapper, new MimeType[]{MediaType.APPLICATION_JSON}));
        }).build();
        return WebClient.builder().filter((request, next) -> {
            this.logRequest(request);
            return next.exchange(this.interceptBody(request)).doOnNext(this::logResponse).map(this::interceptBody);
        }).baseUrl(schwabUri.toString()).exchangeStrategies(strategies).build();
    }

    private ClientRequest interceptBody(ClientRequest request) {
        return ClientRequest.from((ClientRequest)request).body((outputMessage, context) -> request.body().insert((ReactiveHttpOutputMessage)new ClientHttpRequestDecorator((ClientHttpRequest)outputMessage){

            @NonNull
            public Mono<Void> writeWith(@NonNull Publisher<? extends DataBuffer> body) {
                if (body == null) {
                    throw new NullPointerException("body is marked non-null but is null");
                }
                return super.writeWith((Publisher)Mono.from(body).doOnNext(dataBuffer -> SchwabWebClient.this.logRequestBody((DataBuffer)dataBuffer)));
            }
        }, context)).build();
    }

    private ClientResponse interceptBody(ClientResponse response) {
        return response.mutate().body(data -> data.doOnNext(this::logResponseBody)).build();
    }

    private void logRequest(ClientRequest request) {
        log.debug("DOWNSTREAM REQUEST: METHOD {}, URI: {}, HEADERS: {}", new Object[]{request.method(), request.url(), request.headers()});
    }

    private void logRequestBody(DataBuffer dataBuffer) {
        log.debug("DOWNSTREAM REQUEST: BODY: {}", (Object)dataBuffer.toString(StandardCharsets.UTF_8));
    }

    private void logResponse(ClientResponse response) {
        log.debug("DOWNSTREAM RESPONSE: STATUS: {}, HEADERS: {}", (Object)response.statusCode().value(), (Object)response.headers().asHttpHeaders());
    }

    private void logResponseBody(DataBuffer dataBuffer) {
        log.debug("DOWNSTREAM RESPONSE: BODY: {}", (Object)dataBuffer.toString(StandardCharsets.UTF_8));
    }
}

