/*
 * Decompiled with CFR 0.152.
 */
package com.pangility.schwab.api.client.common.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class LocalDateDeserializer
extends JsonDeserializer<LocalDate> {
    public LocalDate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        LocalDate ld;
        String valueAsString = jp.getValueAsString();
        try {
            ld = LocalDate.parse(valueAsString, DateTimeFormatter.ISO_DATE);
        }
        catch (DateTimeParseException dtpe) {
            try {
                LocalDateTime ldt = LocalDateTime.parse(valueAsString, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S"));
                ld = ldt.toLocalDate();
            }
            catch (DateTimeParseException retry) {
                throw dtpe;
            }
        }
        return ld;
    }
}

