/*
 * Decompiled with CFR 0.152.
 */
package com.pangility.schwab.api.client.marketdata;

import com.pangility.schwab.api.client.common.SchwabBaseApiClient;
import com.pangility.schwab.api.client.marketdata.IndexNotFoundException;
import com.pangility.schwab.api.client.marketdata.MarketNotFoundException;
import com.pangility.schwab.api.client.marketdata.SymbolNotFoundException;
import com.pangility.schwab.api.client.marketdata.model.chains.OptionChainRequest;
import com.pangility.schwab.api.client.marketdata.model.chains.OptionChainResponse;
import com.pangility.schwab.api.client.marketdata.model.expirationchain.ExpirationChainResponse;
import com.pangility.schwab.api.client.marketdata.model.instruments.Instrument;
import com.pangility.schwab.api.client.marketdata.model.instruments.InstrumentsRequest;
import com.pangility.schwab.api.client.marketdata.model.instruments.InstrumentsResponse;
import com.pangility.schwab.api.client.marketdata.model.markets.Hours;
import com.pangility.schwab.api.client.marketdata.model.movers.MoversRequest;
import com.pangility.schwab.api.client.marketdata.model.movers.MoversResponse;
import com.pangility.schwab.api.client.marketdata.model.movers.Screener;
import com.pangility.schwab.api.client.marketdata.model.pricehistory.PriceHistoryRequest;
import com.pangility.schwab.api.client.marketdata.model.pricehistory.PriceHistoryResponse;
import com.pangility.schwab.api.client.marketdata.model.quotes.QuoteResponse;
import com.pangility.schwab.api.client.oauth2.SchwabAccount;
import com.pangility.schwab.api.client.oauth2.SchwabTokenHandler;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
@ConditionalOnResource(resources={"classpath:schwabapiclient.properties"})
public class SchwabMarketDataApiClient
extends SchwabBaseApiClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchwabMarketDataApiClient.class);
    @Value(value="${schwab-api.marketDataPath}")
    private String schwabMarketDataPath;
    private String defaultUserId = null;

    @Override
    public void init(@NonNull SchwabAccount schwabAccount, SchwabTokenHandler tokenHandler) {
        if (schwabAccount == null) {
            throw new NullPointerException("schwabAccount is marked non-null but is null");
        }
        this.init(schwabAccount.getUserId(), Collections.singletonList(schwabAccount), tokenHandler);
    }

    @Override
    public void init(@NonNull SchwabAccount schwabAccount) {
        if (schwabAccount == null) {
            throw new NullPointerException("schwabAccount is marked non-null but is null");
        }
        this.init(schwabAccount.getUserId(), Collections.singletonList(schwabAccount), null);
    }

    public void init(@NonNull String defaultUserId, @NonNull List<SchwabAccount> schwabAccounts) {
        if (defaultUserId == null) {
            throw new NullPointerException("defaultUserId is marked non-null but is null");
        }
        if (schwabAccounts == null) {
            throw new NullPointerException("schwabAccounts is marked non-null but is null");
        }
        this.init(defaultUserId, schwabAccounts, null);
    }

    public void init(@NonNull String defaultUserId, @NonNull List<SchwabAccount> schwabAccounts, SchwabTokenHandler tokenHandler) {
        if (defaultUserId == null) {
            throw new NullPointerException("defaultUserId is marked non-null but is null");
        }
        if (schwabAccounts == null) {
            throw new NullPointerException("schwabAccounts is marked non-null but is null");
        }
        this.init(schwabAccounts, tokenHandler);
        this.defaultUserId = defaultUserId;
    }

    @Override
    public Boolean isInitialized() {
        return this.defaultUserId != null && super.isInitialized() != false;
    }

    @Deprecated
    public QuoteResponse fetchQuote(@NonNull String symbol) {
        if (symbol == null) {
            throw new NullPointerException("symbol is marked non-null but is null");
        }
        return this.fetchQuote(symbol, null);
    }

    @Deprecated
    public QuoteResponse fetchQuote(@NonNull String symbol, String fields) {
        if (symbol == null) {
            throw new NullPointerException("symbol is marked non-null but is null");
        }
        return (QuoteResponse)this.fetchQuoteToMono(symbol, fields).block();
    }

    public Mono<QuoteResponse> fetchQuoteToMono(@NonNull String symbol) {
        if (symbol == null) {
            throw new NullPointerException("symbol is marked non-null but is null");
        }
        return this.fetchQuoteToMono(symbol, null);
    }

    public Mono<QuoteResponse> fetchQuoteToMono(@NonNull String symbol, String fields) {
        if (symbol == null) {
            throw new NullPointerException("symbol is marked non-null but is null");
        }
        log.info("Fetch Quote [{}]", (Object)symbol);
        if (fields == null || fields.isEmpty()) {
            fields = "all";
        }
        if (symbol.isEmpty()) {
            throw new IllegalArgumentException("A Quote must include a symbol.");
        }
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{symbol.toUpperCase(), "quotes"}).queryParam("fields", new Object[]{fields});
        Mono quoteResponseMono = this.callGetApiToMono(this.defaultUserId, uriBuilder, new ParameterizedTypeReference<Map<String, QuoteResponse>>(){}).onErrorResume(throwable -> {
            if (throwable instanceof WebClientResponseException && ((WebClientResponseException)throwable).getStatusCode().isSameCodeAs((HttpStatusCode)HttpStatus.NOT_FOUND)) {
                return Mono.error((Throwable)new SymbolNotFoundException("'" + symbol + "' not found"));
            }
            return Mono.error((Throwable)throwable);
        }).flatMap(quoteResponseMap -> {
            if (!quoteResponseMap.isEmpty() && quoteResponseMap.containsKey(symbol)) {
                return Mono.just((Object)((QuoteResponse)quoteResponseMap.get(symbol)));
            }
            return Mono.error((Throwable)new SymbolNotFoundException("'" + symbol + "' not found"));
        });
        return quoteResponseMono;
    }

    @Deprecated
    public Map<String, QuoteResponse> fetchQuotes(@NonNull List<String> symbols) {
        if (symbols == null) {
            throw new NullPointerException("symbols is marked non-null but is null");
        }
        return this.fetchQuotes(symbols, null);
    }

    @Deprecated
    public Map<String, QuoteResponse> fetchQuotes(@NonNull List<String> symbols, String fields) {
        if (symbols == null) {
            throw new NullPointerException("symbols is marked non-null but is null");
        }
        return this.fetchQuotes(symbols, fields, null);
    }

    @Deprecated
    public Map<String, QuoteResponse> fetchQuotes(@NonNull List<String> symbols, String fields, Boolean indicative) {
        if (symbols == null) {
            throw new NullPointerException("symbols is marked non-null but is null");
        }
        return (Map)this.fetchQuotesToMono(symbols, fields, indicative).block();
    }

    public Mono<Map<String, QuoteResponse>> fetchQuotesToMono(@NonNull List<String> symbols) {
        if (symbols == null) {
            throw new NullPointerException("symbols is marked non-null but is null");
        }
        return this.fetchQuotesToMono(symbols, null);
    }

    public Mono<Map<String, QuoteResponse>> fetchQuotesToMono(@NonNull List<String> symbols, String fields) {
        if (symbols == null) {
            throw new NullPointerException("symbols is marked non-null but is null");
        }
        return this.fetchQuotesToMono(symbols, fields, null);
    }

    public Mono<Map<String, QuoteResponse>> fetchQuotesToMono(@NonNull List<String> symbols, String fields, Boolean indicative) {
        if (symbols == null) {
            throw new NullPointerException("symbols is marked non-null but is null");
        }
        log.info("Fetch Quotes -> [{}]", symbols);
        if (fields == null || fields.isEmpty()) {
            fields = "all";
        }
        if (symbols.isEmpty()) {
            throw new IllegalArgumentException("Quotes must include one or more symbols.");
        }
        String symbolsParam = String.join((CharSequence)",", symbols).toUpperCase();
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"quotes"}).queryParam("symbols", new Object[]{symbolsParam}).queryParam("fields", new Object[]{fields});
        if (indicative != null) {
            uriBuilder.queryParam("indicative", new Object[]{indicative});
        }
        return this.callGetApiToMono(this.defaultUserId, uriBuilder, new ParameterizedTypeReference<Map<String, QuoteResponse>>(){}).onErrorResume(throwable -> {
            if (throwable instanceof WebClientResponseException && ((WebClientResponseException)throwable).getStatusCode().isSameCodeAs((HttpStatusCode)HttpStatus.NOT_FOUND)) {
                return Mono.error((Throwable)new SymbolNotFoundException("'" + symbols + "' not found"));
            }
            return Mono.error((Throwable)throwable);
        }).flatMap(quoteResponseMap -> {
            if (!quoteResponseMap.isEmpty() && quoteResponseMap.size() == symbols.size()) {
                return Mono.just((Object)quoteResponseMap);
            }
            return Mono.error((Throwable)new SymbolNotFoundException("One or more '" + symbols + "' symbols not found"));
        });
    }

    @Deprecated
    public OptionChainResponse fetchOptionChain(@NonNull OptionChainRequest chainRequest) {
        if (chainRequest == null) {
            throw new NullPointerException("chainRequest is marked non-null but is null");
        }
        return (OptionChainResponse)this.fetchOptionChainToMono(chainRequest).block();
    }

    public Mono<OptionChainResponse> fetchOptionChainToMono(@NonNull OptionChainRequest chainRequest) {
        if (chainRequest == null) {
            throw new NullPointerException("chainRequest is marked non-null but is null");
        }
        log.info("Fetch Option Chain -> {}", (Object)chainRequest);
        if (chainRequest.getSymbol() == null || chainRequest.getSymbol().isEmpty()) {
            throw new IllegalArgumentException("Symbol cannot be blank.");
        }
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.newInstance().pathSegment(new String[]{this.schwabMarketDataPath, this.schwabApiVersion, "chains"}).queryParam("symbol", new Object[]{chainRequest.getSymbol().toUpperCase()});
        if (chainRequest.getContractType() != null) {
            uriBuilder.queryParam("contractType", new Object[]{chainRequest.getContractType().toString()});
        }
        if (chainRequest.getStrategy() != null) {
            uriBuilder.queryParam("strategy", new Object[]{chainRequest.getStrategy().toString()});
        }
        if (chainRequest.getRange() != null) {
            uriBuilder.queryParam("range", new Object[]{chainRequest.getRange().toString()});
        }
        if (chainRequest.getOptionType() != null) {
            uriBuilder.queryParam("optionType", new Object[]{chainRequest.getOptionType().toString()});
        }
        if (chainRequest.getStrikeCount() != null && chainRequest.getStrikeCount() > 0) {
            uriBuilder.queryParam("strikeCount", new Object[]{chainRequest.getStrikeCount().toString()});
        }
        if (chainRequest.getIncludeQuotes() != null) {
            uriBuilder.queryParam("includeQuotes", new Object[]{chainRequest.getIncludeQuotes().toString()});
        }
        if (chainRequest.getInterval() != null) {
            uriBuilder.queryParam("interval", new Object[]{chainRequest.getInterval().toString()});
        }
        if (chainRequest.getStrike() != null) {
            uriBuilder.queryParam("strike", new Object[]{chainRequest.getStrike().toString()});
        }
        if (chainRequest.getFromDate() != null) {
            uriBuilder.queryParam("fromDate", new Object[]{chainRequest.getFromDate().format(DateTimeFormatter.ISO_DATE_TIME)});
        }
        if (chainRequest.getToDate() != null) {
            uriBuilder.queryParam("toDate", new Object[]{chainRequest.getToDate().format(DateTimeFormatter.ISO_DATE_TIME)});
        }
        if (chainRequest.getVolatility() != null) {
            uriBuilder.queryParam("volatility", new Object[]{chainRequest.getVolatility().toString()});
        }
        if (chainRequest.getUnderlyingPrice() != null) {
            uriBuilder.queryParam("underlyingPrice", new Object[]{chainRequest.getUnderlyingPrice().toString()});
        }
        if (chainRequest.getInterestRate() != null) {
            uriBuilder.queryParam("interestRate", new Object[]{chainRequest.getInterestRate().toString()});
        }
        if (chainRequest.getDaysToExpiration() != null) {
            uriBuilder.queryParam("daysToExpiration", new Object[]{chainRequest.getDaysToExpiration().toString()});
        }
        if (chainRequest.getMonth() != null) {
            uriBuilder.queryParam("month", new Object[]{chainRequest.getMonth().toString().substring(0, 3).toUpperCase()});
        }
        return this.callGetApiToMono(this.defaultUserId, uriBuilder, OptionChainResponse.class).onErrorResume(throwable -> {
            if (throwable instanceof WebClientResponseException && ((WebClientResponseException)throwable).getStatusCode().isSameCodeAs((HttpStatusCode)HttpStatus.NOT_FOUND)) {
                return Mono.error((Throwable)new SymbolNotFoundException("'" + chainRequest.getSymbol() + "' not found"));
            }
            return Mono.error((Throwable)throwable);
        }).flatMap(response -> {
            if (response.getSymbol() != null && !response.getSymbol().isEmpty()) {
                return Mono.just((Object)response);
            }
            return Mono.error((Throwable)new SymbolNotFoundException("'" + chainRequest.getSymbol() + "' not found"));
        });
    }

    @Deprecated
    public ExpirationChainResponse fetchExpirationChain(@NonNull String symbol) {
        if (symbol == null) {
            throw new NullPointerException("symbol is marked non-null but is null");
        }
        return (ExpirationChainResponse)this.fetchExpirationChainToMono(symbol).block();
    }

    public Mono<ExpirationChainResponse> fetchExpirationChainToMono(@NonNull String symbol) {
        if (symbol == null) {
            throw new NullPointerException("symbol is marked non-null but is null");
        }
        log.info("Fetch Expiration Chain -> [{}]", (Object)symbol);
        if (symbol.isEmpty()) {
            throw new IllegalArgumentException("Symbol cannot be blank.");
        }
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"expirationchain"}).queryParam("symbol", new Object[]{symbol.toUpperCase()});
        return this.callGetApiToMono(this.defaultUserId, uriBuilder, ExpirationChainResponse.class).onErrorResume(throwable -> {
            if (throwable instanceof WebClientResponseException && ((WebClientResponseException)throwable).getStatusCode().isSameCodeAs((HttpStatusCode)HttpStatus.NOT_FOUND)) {
                return Mono.error((Throwable)new SymbolNotFoundException("'" + symbol + "' not found"));
            }
            return Mono.error((Throwable)throwable);
        }).flatMap(response -> {
            if (response.getExpirationList() != null && !response.getExpirationList().isEmpty() && response.getExpirationList().get(0).getOptionRoots() != null && response.getExpirationList().get(0).getOptionRoots().equalsIgnoreCase(symbol)) {
                return Mono.just((Object)response);
            }
            return Mono.error((Throwable)new SymbolNotFoundException("'" + symbol + "' not found"));
        });
    }

    @Deprecated
    public PriceHistoryResponse fetchPriceHistory(@NonNull PriceHistoryRequest priceHistReq) {
        if (priceHistReq == null) {
            throw new NullPointerException("priceHistReq is marked non-null but is null");
        }
        return (PriceHistoryResponse)this.fetchPriceHistoryToMono(priceHistReq).block();
    }

    public Mono<PriceHistoryResponse> fetchPriceHistoryToMono(@NonNull PriceHistoryRequest priceHistReq) {
        if (priceHistReq == null) {
            throw new NullPointerException("priceHistReq is marked non-null but is null");
        }
        log.info("Fetch Price History -> {}", (Object)priceHistReq);
        if (priceHistReq.getSymbol() == null || priceHistReq.getSymbol().isEmpty()) {
            throw new IllegalArgumentException("Symbol cannot be blank.");
        }
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.newInstance().pathSegment(new String[]{this.schwabMarketDataPath, this.schwabApiVersion, "pricehistory"}).queryParam("symbol", new Object[]{priceHistReq.getSymbol().toUpperCase()});
        if (priceHistReq.getPeriodType() != null) {
            uriBuilder.queryParam("periodType", new Object[]{priceHistReq.getPeriodType().name()});
        }
        if (priceHistReq.getPeriod() != null) {
            uriBuilder.queryParam("period", new Object[]{String.valueOf(priceHistReq.getPeriod())});
        }
        if (priceHistReq.getFrequencyType() != null) {
            uriBuilder.queryParam("frequencyType", new Object[]{priceHistReq.getFrequencyType().name()});
        }
        if (priceHistReq.getFrequency() != null) {
            uriBuilder.queryParam("frequency", new Object[]{String.valueOf(priceHistReq.getFrequency())});
        }
        if (priceHistReq.getStartDate() != null) {
            long epochStartDay = priceHistReq.getStartDate().toEpochDay() * 86400L * 1000L;
            uriBuilder.queryParam("startDate", new Object[]{String.valueOf(epochStartDay)});
        }
        if (priceHistReq.getEndDate() != null) {
            long epochEndDay = priceHistReq.getEndDate().plusDays(1L).toEpochDay() * 86400L * 1000L;
            uriBuilder.queryParam("endDate", new Object[]{String.valueOf(epochEndDay)});
        }
        if (priceHistReq.getNeedExtendedHoursData() != null) {
            uriBuilder.queryParam("needExtendedHoursData", new Object[]{String.valueOf(priceHistReq.getNeedExtendedHoursData())});
        }
        if (priceHistReq.getNeedPreviousClose() != null) {
            uriBuilder.queryParam("needPreviousClose", new Object[]{String.valueOf(priceHistReq.getNeedPreviousClose())});
        }
        return this.callGetApiToMono(this.defaultUserId, uriBuilder, PriceHistoryResponse.class).onErrorResume(throwable -> {
            if (throwable instanceof WebClientResponseException && ((WebClientResponseException)throwable).getStatusCode().isSameCodeAs((HttpStatusCode)HttpStatus.NOT_FOUND)) {
                return Mono.error((Throwable)new SymbolNotFoundException("'" + priceHistReq.getSymbol() + "' not found"));
            }
            return Mono.error((Throwable)throwable);
        }).doOnSuccess(priceHistoryResponse -> {
            if (priceHistoryResponse.getPreviousCloseDate() != null && priceHistoryResponse.getPreviousCloseDateISO8601() == null) {
                LocalDate ld = Instant.ofEpochMilli(priceHistoryResponse.getPreviousCloseDate()).atZone(ZoneId.systemDefault()).toLocalDate();
                priceHistoryResponse.setPreviousCloseDateISO8601(ld);
            }
            if (priceHistoryResponse.getCandles() != null) {
                priceHistoryResponse.getCandles().forEach(candle -> {
                    if (candle.getDatetime() != null && candle.getDatetimeISO8601() == null) {
                        LocalDateTime ldt = Instant.ofEpochMilli(candle.getDatetime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
                        candle.setDatetimeISO8601(ldt);
                    }
                });
            }
        }).flatMap(response -> {
            if (!response.getEmpty().booleanValue() && response.getSymbol() != null && !response.getSymbol().isEmpty() && response.getSymbol().equalsIgnoreCase(priceHistReq.getSymbol())) {
                return Mono.just((Object)response);
            }
            return Mono.error((Throwable)new SymbolNotFoundException("'" + priceHistReq.getSymbol() + "' not found"));
        });
    }

    @Deprecated
    public MoversResponse fetchMovers(@NonNull MoversRequest moversRequest) {
        if (moversRequest == null) {
            throw new NullPointerException("moversRequest is marked non-null but is null");
        }
        MoversResponse moversResponse = new MoversResponse();
        moversResponse.setScreeners(this.fetchMoversToFlux(moversRequest).toStream().toList());
        return moversResponse;
    }

    public Flux<Screener> fetchMoversToFlux(@NonNull MoversRequest moversRequest) {
        if (moversRequest == null) {
            throw new NullPointerException("moversRequest is marked non-null but is null");
        }
        log.info("Fetch Movers -> {}", (Object)moversRequest);
        if (moversRequest.getIndexSymbol() == null) {
            throw new IllegalArgumentException("Index Symbol cannot be blank.");
        }
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"movers", moversRequest.getIndexSymbol().toString()});
        return this.callGetApiToMono(this.defaultUserId, uriBuilder, MoversResponse.class).onErrorResume(throwable -> {
            if (throwable instanceof WebClientResponseException && ((WebClientResponseException)throwable).getStatusCode().isSameCodeAs((HttpStatusCode)HttpStatus.NOT_FOUND)) {
                return Mono.error((Throwable)new IndexNotFoundException("Movers for '" + moversRequest.getIndexSymbol().toString() + "' not found"));
            }
            return Mono.error((Throwable)throwable);
        }).flux().flatMap(moversResponse -> Flux.fromIterable(moversResponse.getScreeners()));
    }

    @Deprecated
    public Map<String, Map<String, Hours>> fetchMarket(@NonNull Market market) {
        if (market == null) {
            throw new NullPointerException("market is marked non-null but is null");
        }
        return this.fetchMarket(market, null);
    }

    @Deprecated
    public Map<String, Map<String, Hours>> fetchMarket(@NonNull Market market, LocalDate date) {
        if (market == null) {
            throw new NullPointerException("market is marked non-null but is null");
        }
        return this.fetchMarkets(Collections.singletonList(market), date);
    }

    @Deprecated
    public Map<String, Map<String, Hours>> fetchMarkets(@NonNull List<Market> markets) {
        if (markets == null) {
            throw new NullPointerException("markets is marked non-null but is null");
        }
        return this.fetchMarkets(markets, null);
    }

    @Deprecated
    public Map<String, Map<String, Hours>> fetchMarkets(@NonNull List<Market> markets, LocalDate date) {
        if (markets == null) {
            throw new NullPointerException("markets is marked non-null but is null");
        }
        return (Map)this.fetchMarketsToMono(markets, date).block();
    }

    public Mono<Map<String, Map<String, Hours>>> fetchMarketToMono(@NonNull Market market) {
        if (market == null) {
            throw new NullPointerException("market is marked non-null but is null");
        }
        return this.fetchMarketToMono(market, null);
    }

    public Mono<Map<String, Map<String, Hours>>> fetchMarketToMono(@NonNull Market market, LocalDate date) {
        if (market == null) {
            throw new NullPointerException("market is marked non-null but is null");
        }
        return this.fetchMarketsToMono(Collections.singletonList(market), date);
    }

    public Mono<Map<String, Map<String, Hours>>> fetchMarketsToMono(@NonNull List<Market> markets) {
        if (markets == null) {
            throw new NullPointerException("markets is marked non-null but is null");
        }
        return this.fetchMarketsToMono(markets, null);
    }

    public Mono<Map<String, Map<String, Hours>>> fetchMarketsToMono(@NonNull List<Market> markets, LocalDate date) {
        if (markets == null) {
            throw new NullPointerException("markets is marked non-null but is null");
        }
        log.info("Fetch Market Hours -> {}", markets);
        if (markets.isEmpty()) {
            throw new IllegalArgumentException("At least one market is required to fetch Market Hours.");
        }
        String marketsString = String.join((CharSequence)",", (CharSequence[])markets.stream().map(Market::value).toArray(String[]::new));
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"markets"}).queryParam("markets", new Object[]{marketsString});
        if (date != null) {
            uriBuilder.queryParam("date", new Object[]{date.format(DateTimeFormatter.ISO_DATE)});
        }
        return this.callGetApiToMono(this.defaultUserId, uriBuilder, new ParameterizedTypeReference<Map<String, Map<String, Hours>>>(){}).onErrorResume(throwable -> {
            if (throwable instanceof WebClientResponseException && ((WebClientResponseException)throwable).getStatusCode().isSameCodeAs((HttpStatusCode)HttpStatus.NOT_FOUND)) {
                return Mono.error((Throwable)new MarketNotFoundException("Market Hours for '" + markets + "' not found"));
            }
            return Mono.error((Throwable)throwable);
        }).flatMap(response -> {
            if (!response.isEmpty()) {
                return Mono.just((Object)response);
            }
            return Mono.error((Throwable)new MarketNotFoundException("Market Hours for '" + markets + "' not found"));
        });
    }

    @Deprecated
    public InstrumentsResponse fetchInstruments(@NonNull InstrumentsRequest instrumentsRequest) {
        if (instrumentsRequest == null) {
            throw new NullPointerException("instrumentsRequest is marked non-null but is null");
        }
        InstrumentsResponse instrumentsResponse = new InstrumentsResponse();
        instrumentsResponse.setInstruments(this.fetchInstrumentsToFlux(instrumentsRequest).toStream().toList());
        return instrumentsResponse;
    }

    public Flux<Instrument> fetchInstrumentsToFlux(@NonNull InstrumentsRequest instrumentsRequest) {
        if (instrumentsRequest == null) {
            throw new NullPointerException("instrumentsRequest is marked non-null but is null");
        }
        log.info("Fetch Instruments -> {}", (Object)instrumentsRequest);
        if (instrumentsRequest.getSymbol() == null || instrumentsRequest.getSymbol().isEmpty() || instrumentsRequest.getProjection() == null) {
            throw new IllegalArgumentException("A request for Instruments must include a symbol and a projection.");
        }
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"instruments"}).queryParam("symbol", new Object[]{instrumentsRequest.getSymbol()}).queryParam("projection", new Object[]{instrumentsRequest.getProjection().value()});
        return this.callGetApiToMono(this.defaultUserId, uriBuilder, InstrumentsResponse.class).flatMap(instrumentsResponse -> {
            if (instrumentsResponse.getInstruments() == null) {
                return Mono.error((Throwable)new SymbolNotFoundException("Instruments for '" + instrumentsRequest.getSymbol() + "' not found"));
            }
            return Mono.just((Object)instrumentsResponse);
        }).flux().flatMap(instrumentsResponse -> Flux.fromIterable(instrumentsResponse.getInstruments()));
    }

    @Deprecated
    public InstrumentsResponse fetchInstrumentsByCusip(@NonNull String cusip) {
        if (cusip == null) {
            throw new NullPointerException("cusip is marked non-null but is null");
        }
        Instrument instrument = (Instrument)this.fetchInstrumentByCusipToMono(cusip).block();
        InstrumentsResponse instrumentsResponse = new InstrumentsResponse();
        if (instrument != null) {
            instrumentsResponse.setInstruments(List.of(instrument));
        }
        return instrumentsResponse;
    }

    public Mono<Instrument> fetchInstrumentByCusipToMono(@NonNull String cusip) {
        if (cusip == null) {
            throw new NullPointerException("cusip is marked non-null but is null");
        }
        log.info("Fetch Instrument by cusip [{}]", (Object)cusip);
        if (cusip.isEmpty()) {
            throw new IllegalArgumentException("Cusip is required");
        }
        UriComponentsBuilder uriBuilder = this.getUriBuilder().pathSegment(new String[]{"instruments", cusip});
        return this.callGetApiToMono(this.defaultUserId, uriBuilder, InstrumentsResponse.class).onErrorResume(throwable -> {
            if (throwable instanceof WebClientResponseException && ((WebClientResponseException)throwable).getStatusCode().isSameCodeAs((HttpStatusCode)HttpStatus.NOT_FOUND)) {
                return Mono.error((Throwable)new SymbolNotFoundException("Instrument for cusip '" + cusip + "' not found"));
            }
            return Mono.error((Throwable)throwable);
        }).flatMap(instrumentResponse -> {
            if (instrumentResponse.getInstruments() == null || instrumentResponse.getInstruments().isEmpty()) {
                return Mono.error((Throwable)new SymbolNotFoundException("Instrument for cusip '" + cusip + "' not found"));
            }
            return Mono.just((Object)instrumentResponse.getInstruments().get(0));
        });
    }

    private UriComponentsBuilder getUriBuilder() {
        return UriComponentsBuilder.newInstance().pathSegment(new String[]{this.schwabMarketDataPath, this.schwabApiVersion});
    }

    public static enum Market {
        EQUITY("equity"),
        OPTION("option"),
        BOND("bond"),
        FUTURE("future"),
        FOREX("forex");

        private final String value;
        private static final Map<String, Market> CONSTANTS;

        private Market(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static Market fromValue(String value) {
            Market constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Market>();
            for (Market c : Market.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

