/*
 * Decompiled with CFR 0.152.
 */
package com.pangility.schwab.api.client.marketdata.model.chains;

import java.time.LocalDateTime;
import java.time.Month;
import lombok.Generated;

public class OptionChainRequest {
    private String symbol;
    private ContractType contractType;
    private Integer strikeCount;
    private Boolean includeQuotes;
    private Strategy strategy;
    private Double interval;
    private Double strike;
    private Range range;
    private LocalDateTime fromDate;
    private LocalDateTime toDate;
    private Double volatility;
    private Double underlyingPrice;
    private Double interestRate;
    private Integer daysToExpiration;
    private Month month;
    private OptionType optionType;

    @Generated
    public static OptionChainRequestBuilder builder() {
        return new OptionChainRequestBuilder();
    }

    @Generated
    public String getSymbol() {
        return this.symbol;
    }

    @Generated
    public ContractType getContractType() {
        return this.contractType;
    }

    @Generated
    public Integer getStrikeCount() {
        return this.strikeCount;
    }

    @Generated
    public Boolean getIncludeQuotes() {
        return this.includeQuotes;
    }

    @Generated
    public Strategy getStrategy() {
        return this.strategy;
    }

    @Generated
    public Double getInterval() {
        return this.interval;
    }

    @Generated
    public Double getStrike() {
        return this.strike;
    }

    @Generated
    public Range getRange() {
        return this.range;
    }

    @Generated
    public LocalDateTime getFromDate() {
        return this.fromDate;
    }

    @Generated
    public LocalDateTime getToDate() {
        return this.toDate;
    }

    @Generated
    public Double getVolatility() {
        return this.volatility;
    }

    @Generated
    public Double getUnderlyingPrice() {
        return this.underlyingPrice;
    }

    @Generated
    public Double getInterestRate() {
        return this.interestRate;
    }

    @Generated
    public Integer getDaysToExpiration() {
        return this.daysToExpiration;
    }

    @Generated
    public Month getMonth() {
        return this.month;
    }

    @Generated
    public OptionType getOptionType() {
        return this.optionType;
    }

    @Generated
    public String toString() {
        return "OptionChainRequest(symbol=" + this.getSymbol() + ", contractType=" + this.getContractType() + ", strikeCount=" + this.getStrikeCount() + ", includeQuotes=" + this.getIncludeQuotes() + ", strategy=" + this.getStrategy() + ", interval=" + this.getInterval() + ", strike=" + this.getStrike() + ", range=" + this.getRange() + ", fromDate=" + this.getFromDate() + ", toDate=" + this.getToDate() + ", volatility=" + this.getVolatility() + ", underlyingPrice=" + this.getUnderlyingPrice() + ", interestRate=" + this.getInterestRate() + ", daysToExpiration=" + this.getDaysToExpiration() + ", month=" + this.getMonth() + ", optionType=" + this.getOptionType() + ")";
    }

    @Generated
    public OptionChainRequest() {
    }

    @Generated
    public OptionChainRequest(String symbol, ContractType contractType, Integer strikeCount, Boolean includeQuotes, Strategy strategy, Double interval, Double strike, Range range, LocalDateTime fromDate, LocalDateTime toDate, Double volatility, Double underlyingPrice, Double interestRate, Integer daysToExpiration, Month month, OptionType optionType) {
        this.symbol = symbol;
        this.contractType = contractType;
        this.strikeCount = strikeCount;
        this.includeQuotes = includeQuotes;
        this.strategy = strategy;
        this.interval = interval;
        this.strike = strike;
        this.range = range;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.volatility = volatility;
        this.underlyingPrice = underlyingPrice;
        this.interestRate = interestRate;
        this.daysToExpiration = daysToExpiration;
        this.month = month;
        this.optionType = optionType;
    }

    @Generated
    public static class OptionChainRequestBuilder {
        @Generated
        private String symbol;
        @Generated
        private ContractType contractType;
        @Generated
        private Integer strikeCount;
        @Generated
        private Boolean includeQuotes;
        @Generated
        private Strategy strategy;
        @Generated
        private Double interval;
        @Generated
        private Double strike;
        @Generated
        private Range range;
        @Generated
        private LocalDateTime fromDate;
        @Generated
        private LocalDateTime toDate;
        @Generated
        private Double volatility;
        @Generated
        private Double underlyingPrice;
        @Generated
        private Double interestRate;
        @Generated
        private Integer daysToExpiration;
        @Generated
        private Month month;
        @Generated
        private OptionType optionType;

        @Generated
        OptionChainRequestBuilder() {
        }

        @Generated
        public OptionChainRequestBuilder withSymbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        @Generated
        public OptionChainRequestBuilder withContractType(ContractType contractType) {
            this.contractType = contractType;
            return this;
        }

        @Generated
        public OptionChainRequestBuilder withStrikeCount(Integer strikeCount) {
            this.strikeCount = strikeCount;
            return this;
        }

        @Generated
        public OptionChainRequestBuilder withIncludeQuotes(Boolean includeQuotes) {
            this.includeQuotes = includeQuotes;
            return this;
        }

        @Generated
        public OptionChainRequestBuilder withStrategy(Strategy strategy) {
            this.strategy = strategy;
            return this;
        }

        @Generated
        public OptionChainRequestBuilder withInterval(Double interval) {
            this.interval = interval;
            return this;
        }

        @Generated
        public OptionChainRequestBuilder withStrike(Double strike) {
            this.strike = strike;
            return this;
        }

        @Generated
        public OptionChainRequestBuilder withRange(Range range) {
            this.range = range;
            return this;
        }

        @Generated
        public OptionChainRequestBuilder withFromDate(LocalDateTime fromDate) {
            this.fromDate = fromDate;
            return this;
        }

        @Generated
        public OptionChainRequestBuilder withToDate(LocalDateTime toDate) {
            this.toDate = toDate;
            return this;
        }

        @Generated
        public OptionChainRequestBuilder withVolatility(Double volatility) {
            this.volatility = volatility;
            return this;
        }

        @Generated
        public OptionChainRequestBuilder withUnderlyingPrice(Double underlyingPrice) {
            this.underlyingPrice = underlyingPrice;
            return this;
        }

        @Generated
        public OptionChainRequestBuilder withInterestRate(Double interestRate) {
            this.interestRate = interestRate;
            return this;
        }

        @Generated
        public OptionChainRequestBuilder withDaysToExpiration(Integer daysToExpiration) {
            this.daysToExpiration = daysToExpiration;
            return this;
        }

        @Generated
        public OptionChainRequestBuilder withMonth(Month month) {
            this.month = month;
            return this;
        }

        @Generated
        public OptionChainRequestBuilder withOptionType(OptionType optionType) {
            this.optionType = optionType;
            return this;
        }

        @Generated
        public OptionChainRequest build() {
            return new OptionChainRequest(this.symbol, this.contractType, this.strikeCount, this.includeQuotes, this.strategy, this.interval, this.strike, this.range, this.fromDate, this.toDate, this.volatility, this.underlyingPrice, this.interestRate, this.daysToExpiration, this.month, this.optionType);
        }

        @Generated
        public String toString() {
            return "OptionChainRequest.OptionChainRequestBuilder(symbol=" + this.symbol + ", contractType=" + this.contractType + ", strikeCount=" + this.strikeCount + ", includeQuotes=" + this.includeQuotes + ", strategy=" + this.strategy + ", interval=" + this.interval + ", strike=" + this.strike + ", range=" + this.range + ", fromDate=" + this.fromDate + ", toDate=" + this.toDate + ", volatility=" + this.volatility + ", underlyingPrice=" + this.underlyingPrice + ", interestRate=" + this.interestRate + ", daysToExpiration=" + this.daysToExpiration + ", month=" + this.month + ", optionType=" + this.optionType + ")";
        }
    }

    public static enum ContractType {
        CALL,
        PUT,
        ALL;

    }

    public static enum Strategy {
        SINGLE,
        ANALYTICAL,
        COVERED,
        VERTICAL,
        CALENDAR,
        STRANGLE,
        STRADDLE,
        BUTTERFLY,
        CONDOR,
        DIAGONAL,
        COLLAR,
        ROLL;

    }

    public static enum Range {
        ITM,
        NTM,
        OTM,
        SAK,
        SBK,
        SNK,
        ALL;

    }

    public static enum OptionType {
        S,
        NS,
        ALL;

    }

    @Deprecated
    public static final class Builder {
        private String symbol;
        private ContractType contractType;
        private Integer strikeCount;
        private Boolean includeQuotes;
        private Strategy strategy;
        private Double interval;
        private Double strike;
        private Range range;
        private LocalDateTime fromDate;
        private LocalDateTime toDate;
        private Double volatility;
        private Double underlyingPrice;
        private Double interestRate;
        private Integer daysToExpiration;
        private Month month;
        private OptionType optionType;

        @Deprecated
        public static Builder optionChainRequest() {
            return new Builder();
        }

        @Deprecated
        public Builder withSymbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        @Deprecated
        public Builder withContractType(ContractType contractType) {
            this.contractType = contractType;
            return this;
        }

        @Deprecated
        public Builder withStrikeCount(Integer strikeCount) {
            this.strikeCount = strikeCount;
            return this;
        }

        @Deprecated
        public Builder withIncludeQuotes(Boolean includeQuotes) {
            this.includeQuotes = includeQuotes;
            return this;
        }

        @Deprecated
        public Builder withStrategy(Strategy strategy) {
            this.strategy = strategy;
            return this;
        }

        @Deprecated
        public Builder withInterval(Double interval) {
            this.interval = interval;
            return this;
        }

        @Deprecated
        public Builder withStrike(Double strike) {
            this.strike = strike;
            return this;
        }

        @Deprecated
        public Builder withRange(Range range) {
            this.range = range;
            return this;
        }

        @Deprecated
        public Builder withFromDate(LocalDateTime fromDate) {
            this.fromDate = fromDate;
            return this;
        }

        @Deprecated
        public Builder withToDate(LocalDateTime toDate) {
            this.toDate = toDate;
            return this;
        }

        @Deprecated
        public Builder withVolatility(Double volatility) {
            this.volatility = volatility;
            return this;
        }

        @Deprecated
        public Builder withUnderlyingPrice(Double underlyingPrice) {
            this.underlyingPrice = underlyingPrice;
            return this;
        }

        @Deprecated
        public Builder withInterestRate(Double interestRate) {
            this.interestRate = interestRate;
            return this;
        }

        @Deprecated
        public Builder withDaysToExpiration(Integer daysToExpiration) {
            this.daysToExpiration = daysToExpiration;
            return this;
        }

        @Deprecated
        public Builder withMonth(Month month) {
            this.month = month;
            return this;
        }

        @Deprecated
        public Builder withOptionType(OptionType optionType) {
            this.optionType = optionType;
            return this;
        }

        @Deprecated
        public OptionChainRequest build() {
            OptionChainRequest optionChainRequest = new OptionChainRequest();
            optionChainRequest.symbol = this.symbol;
            optionChainRequest.contractType = this.contractType;
            optionChainRequest.strikeCount = this.strikeCount;
            optionChainRequest.includeQuotes = this.includeQuotes;
            optionChainRequest.strategy = this.strategy;
            optionChainRequest.interval = this.interval;
            optionChainRequest.strike = this.strike;
            optionChainRequest.range = this.range;
            optionChainRequest.fromDate = this.fromDate;
            optionChainRequest.toDate = this.toDate;
            optionChainRequest.volatility = this.volatility;
            optionChainRequest.underlyingPrice = this.underlyingPrice;
            optionChainRequest.interestRate = this.interestRate;
            optionChainRequest.daysToExpiration = this.daysToExpiration;
            optionChainRequest.month = this.month;
            optionChainRequest.optionType = this.optionType;
            return optionChainRequest;
        }

        @Generated
        public Builder() {
        }
    }
}

