/*
 * Decompiled with CFR 0.152.
 */
package com.pangility.schwab.api.client.oauth2;

import com.pangility.schwab.api.client.common.ApiUnauthorizedException;
import com.pangility.schwab.api.client.common.OnApiEnabledCondition;
import com.pangility.schwab.api.client.oauth2.RefreshTokenException;
import com.pangility.schwab.api.client.oauth2.SchwabAccount;
import com.pangility.schwab.api.client.oauth2.SchwabTokenHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

@RestController
@Conditional(value={OnApiEnabledCondition.class})
public class SchwabOauth2Controller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchwabOauth2Controller.class);
    @Value(value="${schwab-api.targetUrl}")
    private String schwabTargetUrl;
    @Value(value="${schwab-api.marketDataPath}")
    private String schwabMarketDataPath;
    @Value(value="${schwab-api.apiVersion}")
    private String schwabApiVersion;
    @Value(value="${schwab-api.oauth2.authorization-uri}")
    private String schwabAuthorizationUri;
    @Value(value="${schwab-api.oauth2.authorization-grant-type}")
    private String schwabAuthorizationGrantType;
    @Value(value="${schwab-api.oauth2.refresh-grant-type}")
    private String schwabRefreshGrantType;
    @Value(value="${schwab-api.oauth2.authorization-scope}")
    private String schwabAuthorizationScope;
    @Value(value="${schwab-api.oauth2.token-uri}")
    private String schwabTokenUri;
    @Value(value="${schwab-api.oauth2.redirect-uri}")
    private String schwabRedirectUri;
    @Value(value="${schwab-api.oauth2.clientId}")
    private String schwabClientId;
    @Value(value="${schwab-api.oauth2.clientSecret}")
    private String schwabClientSecret;
    private final HashMap<String, SchwabAccount> accountMapByUserId = new HashMap();
    private final HashMap<UUID, UuidMapInfo> uuids = new HashMap();
    private SchwabTokenHandler tokenHandler = null;

    public void init(@NonNull List<SchwabAccount> schwabAccounts) {
        if (schwabAccounts == null) {
            throw new NullPointerException("schwabAccounts is marked non-null but is null");
        }
        this.init(schwabAccounts, null);
    }

    public void init(@NonNull List<SchwabAccount> schwabAccounts, SchwabTokenHandler tokenHandler) {
        if (schwabAccounts == null) {
            throw new NullPointerException("schwabAccounts is marked non-null but is null");
        }
        schwabAccounts.forEach(schwabAccount -> this.accountMapByUserId.put(schwabAccount.getUserId(), (SchwabAccount)schwabAccount));
        this.tokenHandler = tokenHandler;
    }

    public Boolean isInitialized() {
        return !this.accountMapByUserId.isEmpty();
    }

    @Deprecated
    public void validateRefreshToken(SchwabAccount schwabAccount) throws RefreshTokenException {
        if (schwabAccount == null) {
            throw new RefreshTokenException("Unable to retrieve Refresh Token", schwabAccount);
        }
        if (schwabAccount.getRefreshToken() == null) {
            throw new RefreshTokenException("Missing Refresh Token", schwabAccount);
        }
        if (LocalDateTime.now().plusMinutes(60L).isAfter(schwabAccount.getRefreshExpiration())) {
            throw new RefreshTokenException("Expired Refresh Token", schwabAccount);
        }
    }

    public Mono<SchwabAccount> validateRefreshTokenToMono(SchwabAccount schwabAccount) {
        if (schwabAccount == null) {
            return Mono.error((Throwable)new RefreshTokenException("Unable to retrieve Refresh Token", schwabAccount));
        }
        if (schwabAccount.getRefreshToken() == null) {
            return Mono.error((Throwable)new RefreshTokenException("Missing Refresh Token", schwabAccount));
        }
        if (LocalDateTime.now().plusMinutes(60L).isAfter(schwabAccount.getRefreshExpiration())) {
            return Mono.error((Throwable)new RefreshTokenException("Expired Refresh Token", schwabAccount));
        }
        return Mono.just((Object)schwabAccount);
    }

    public SchwabAccount getSchwabAccount(@NonNull String schwabUserId) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        return this.accountMapByUserId.get(schwabUserId);
    }

    public Mono<SchwabAccount> getAccessToken(@NonNull String schwabUserId) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        Mono schwabAccountMono = Mono.empty();
        SchwabAccount schwabAccount = this.accountMapByUserId.get(schwabUserId);
        if (schwabAccount != null) {
            return this.validateRefreshTokenToMono(schwabAccount).flatMap(validatedSchwabAccount -> {
                String accessToken = schwabAccount.getAccessToken();
                LocalDateTime accessExpiration = schwabAccount.getAccessExpiration();
                if (accessToken == null || accessExpiration != null && LocalDateTime.now().plusMinutes(5L).isAfter(accessExpiration)) {
                    return this.refreshAccessToken(schwabAccount);
                }
                return Mono.just((Object)schwabAccount);
            });
        }
        return schwabAccountMono;
    }

    public Mono<SchwabAccount> refreshAccessToken(@NonNull String schwabUserId) {
        if (schwabUserId == null) {
            throw new NullPointerException("schwabUserId is marked non-null but is null");
        }
        Mono<SchwabAccount> response = Mono.empty();
        SchwabAccount schwabAccount = this.accountMapByUserId.get(schwabUserId);
        if (schwabAccount != null) {
            response = this.refreshAccessToken(schwabAccount);
        }
        return response;
    }

    public Mono<SchwabAccount> refreshAccessToken(@NonNull SchwabAccount schwabAccount) {
        if (schwabAccount == null) {
            throw new NullPointerException("schwabAccount is marked non-null but is null");
        }
        String tokenAuthorizationHeader = "Basic " + new String(Base64.getMimeEncoder().encode((this.schwabClientId + ":" + this.schwabClientSecret).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        URI uri = UriComponentsBuilder.newInstance().scheme("https").host(this.schwabTargetUrl).pathSegment(new String[]{this.schwabApiVersion, this.schwabTokenUri}).build().toUri();
        LinkedMultiValueMap bodyValues = new LinkedMultiValueMap();
        bodyValues.add((Object)"grant_type", (Object)this.schwabRefreshGrantType);
        bodyValues.add((Object)"refresh_token", (Object)schwabAccount.getRefreshToken());
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)WebClient.create().post().uri(uri)).header("Authorization", new String[]{tokenAuthorizationHeader})).contentType(MediaType.APPLICATION_FORM_URLENCODED).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body((BodyInserter)BodyInserters.fromFormData((MultiValueMap)bodyValues)).exchangeToMono(clientResponse -> {
            if (clientResponse.statusCode().is2xxSuccessful()) {
                return clientResponse.bodyToMono(AuthorizationTokenInfo.class);
            }
            if (clientResponse.statusCode().is4xxClientError() || clientResponse.statusCode().is5xxServerError()) {
                if (clientResponse.statusCode().isSameCodeAs((HttpStatusCode)HttpStatus.UNAUTHORIZED)) {
                    return Mono.error((Throwable)new ApiUnauthorizedException());
                }
                return Mono.error((Throwable)new ResponseStatusException(clientResponse.statusCode()));
            }
            return Mono.empty();
        }).onErrorResume(throwable -> {
            if (throwable instanceof ApiUnauthorizedException) {
                schwabAccount.setAccessToken(null);
            }
            return Mono.error((Throwable)throwable);
        }).retryWhen((Retry)Retry.backoff((long)2L, (Duration)Duration.ZERO).filter(throwable -> throwable instanceof ApiUnauthorizedException)).flatMap(tokenInfo -> {
            schwabAccount.setAccessToken(tokenInfo.getAccess_token());
            schwabAccount.setAccessExpiration(LocalDateTime.now().plusSeconds(tokenInfo.getExpires_in()));
            if (this.accountMapByUserId.containsKey(schwabAccount.getUserId())) {
                this.accountMapByUserId.replace(schwabAccount.getUserId(), schwabAccount);
            } else {
                this.accountMapByUserId.put(schwabAccount.getUserId(), schwabAccount);
            }
            if (this.tokenHandler != null) {
                this.tokenHandler.onAccessTokenChange(schwabAccount);
            }
            return Mono.just((Object)schwabAccount);
        }).onErrorResume(e -> {
            if (e instanceof WebClientResponseException) {
                WebClientResponseException wcre = (WebClientResponseException)e;
                String errorBody = "Unable to retrieve token: " + wcre.getResponseBodyAsString().replaceAll("\n", "").replaceAll(" ", "").replaceAll("\\{", "{ ").replaceAll("}", " }").replaceAll(":", " : ").replaceAll(",", ", ");
                log.error(errorBody);
                return Mono.error((Throwable)new ResponseStatusException(wcre.getStatusCode(), errorBody, (Throwable)wcre));
            }
            if (e instanceof ResponseStatusException) {
                ResponseStatusException rse = (ResponseStatusException)e;
                return Mono.error((Throwable)rse);
            }
            log.error(this.exceptionToString((Exception)e));
            return Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, this.exceptionToString((Exception)e), e));
        });
    }

    @GetMapping(value={"/oauth2/schwab/code"})
    public Mono<RedirectView> processCode(@RequestParam String code, @RequestParam String state) {
        String tokenAuthorizationHeader = "Basic " + new String(Base64.getMimeEncoder().encode((this.schwabClientId + ":" + this.schwabClientSecret).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        UUID paramUuid = UUID.fromString(state);
        if (this.uuids.containsKey(paramUuid)) {
            UuidMapInfo uuidMapInfo = this.uuids.get(paramUuid);
            String schwabUserId = uuidMapInfo.getUserId();
            String callback = uuidMapInfo.getCallback();
            URI uri = UriComponentsBuilder.newInstance().scheme("https").host(this.schwabTargetUrl).pathSegment(new String[]{this.schwabApiVersion, this.schwabTokenUri}).build().toUri();
            LinkedMultiValueMap bodyValues = new LinkedMultiValueMap();
            bodyValues.add((Object)"grant_type", (Object)this.schwabAuthorizationGrantType);
            bodyValues.add((Object)"access_type", (Object)"offline");
            bodyValues.add((Object)"code", (Object)code);
            bodyValues.add((Object)"client_id", (Object)this.schwabClientId);
            bodyValues.add((Object)"redirect_uri", (Object)this.schwabRedirectUri);
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)WebClient.create().post().uri(uri)).header("Authorization", new String[]{tokenAuthorizationHeader})).contentType(MediaType.APPLICATION_FORM_URLENCODED).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body((BodyInserter)BodyInserters.fromFormData((MultiValueMap)bodyValues)).exchangeToMono(clientResponse -> {
                if (clientResponse.statusCode().is2xxSuccessful()) {
                    return clientResponse.bodyToMono(AuthorizationTokenInfo.class);
                }
                if (clientResponse.statusCode().is4xxClientError() || clientResponse.statusCode().is5xxServerError()) {
                    return Mono.error((Throwable)new ResponseStatusException(clientResponse.statusCode()));
                }
                return Mono.empty();
            }).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofSeconds(2L))).flatMap(tokenInfo -> {
                SchwabAccount schwabAccount;
                if (!this.accountMapByUserId.containsKey(schwabUserId)) {
                    schwabAccount = new SchwabAccount();
                    schwabAccount.setUserId(schwabUserId);
                } else {
                    schwabAccount = this.accountMapByUserId.get(schwabUserId);
                }
                if (schwabAccount != null) {
                    schwabAccount.setRefreshToken(tokenInfo.getRefresh_token());
                    schwabAccount.setRefreshExpiration(LocalDateTime.now().plusDays(7L));
                    schwabAccount.setAccessToken(tokenInfo.getAccess_token());
                    schwabAccount.setAccessExpiration(LocalDateTime.now().plusSeconds(tokenInfo.getExpires_in()));
                    if (this.accountMapByUserId.containsKey(schwabUserId)) {
                        this.accountMapByUserId.replace(schwabUserId, schwabAccount);
                    } else {
                        this.accountMapByUserId.put(schwabUserId, schwabAccount);
                    }
                    if (this.tokenHandler != null) {
                        this.tokenHandler.onRefreshTokenChange(schwabAccount);
                    }
                    return Mono.just((Object)new RedirectView(callback));
                }
                return Mono.error((Throwable)new RefreshTokenException("Unable to retrieve refresh token", null));
            }).onErrorResume(e -> {
                if (e instanceof WebClientResponseException) {
                    WebClientResponseException wcre = (WebClientResponseException)e;
                    String errorBody = "Unable to retrieve token: " + wcre.getResponseBodyAsString().replaceAll("\n", "").replaceAll(" ", "").replaceAll("\\{", "{ ").replaceAll("}", " }").replaceAll(":", " : ").replaceAll(",", ", ");
                    log.error(errorBody);
                    return Mono.error((Throwable)new ResponseStatusException(wcre.getStatusCode(), errorBody, (Throwable)wcre));
                }
                log.error(this.exceptionToString((Exception)e));
                return Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, this.exceptionToString((Exception)e), e));
            });
        }
        return Mono.empty();
    }

    @GetMapping(value={"/oauth2/schwab/authorization"})
    public RedirectView authorize(RedirectAttributes attributes, @RequestParam String schwabUserId, @RequestParam String callback) {
        if (this.isInitialized().booleanValue()) {
            try {
                UUID uuid = UUID.randomUUID();
                UuidMapInfo uuidMapInfo = new UuidMapInfo();
                uuidMapInfo.setUserId(schwabUserId);
                uuidMapInfo.setCallback(callback);
                this.uuids.put(uuid, uuidMapInfo);
                URI uri = UriComponentsBuilder.newInstance().scheme("https").host(this.schwabTargetUrl).pathSegment(new String[]{this.schwabApiVersion, this.schwabAuthorizationUri}).build().toUri();
                attributes.addAttribute("response_type", (Object)"code");
                attributes.addAttribute("redirect_uri", (Object)this.schwabRedirectUri);
                attributes.addAttribute("client_id", (Object)this.schwabClientId);
                attributes.addAttribute("scope", (Object)this.schwabAuthorizationScope);
                attributes.addAttribute("state", (Object)uuid.toString());
                return new RedirectView(uri.toString());
            }
            catch (Exception e) {
                log.error(this.exceptionToString(e));
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, this.exceptionToString(e), (Throwable)e);
            }
        }
        String errorMsg = "Initialization Error: Unable to get Refresh Token before service initialization";
        log.error(errorMsg);
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED, errorMsg);
    }

    private String exceptionToString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private static class UuidMapInfo {
        private String userId;
        private String callback;

        private UuidMapInfo() {
        }

        @Generated
        public String getUserId() {
            return this.userId;
        }

        @Generated
        public String getCallback() {
            return this.callback;
        }

        @Generated
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @Generated
        public void setCallback(String callback) {
            this.callback = callback;
        }
    }

    private static class AuthorizationTokenInfo {
        private Long expires_in;
        private String token_type;
        private String scope;
        private String refresh_token;
        private String access_token;
        private String id_token;

        private AuthorizationTokenInfo() {
        }

        @Generated
        public Long getExpires_in() {
            return this.expires_in;
        }

        @Generated
        public String getToken_type() {
            return this.token_type;
        }

        @Generated
        public String getScope() {
            return this.scope;
        }

        @Generated
        public String getRefresh_token() {
            return this.refresh_token;
        }

        @Generated
        public String getAccess_token() {
            return this.access_token;
        }

        @Generated
        public String getId_token() {
            return this.id_token;
        }

        @Generated
        public String toString() {
            return "SchwabOauth2Controller.AuthorizationTokenInfo(expires_in=" + this.getExpires_in() + ", token_type=" + this.getToken_type() + ", scope=" + this.getScope() + ", refresh_token=" + this.getRefresh_token() + ", access_token=" + this.getAccess_token() + ", id_token=" + this.getId_token() + ")";
        }
    }
}

