/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.foundation;

import com.paritytrading.foundation.ByteArrays;
import com.paritytrading.foundation.Longs;
import java.nio.charset.StandardCharsets;

public class ASCII {
    private ASCII() {
    }

    public static String get(byte[] bytes) {
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    public static void get(byte[] bytes, StringBuilder b) {
        for (int i = 0; i < bytes.length; ++i) {
            b.append((char)bytes[i]);
        }
    }

    public static byte[] put(String s) {
        return s.getBytes(StandardCharsets.US_ASCII);
    }

    public static void putLeft(byte[] bytes, CharSequence s) {
        int i;
        for (i = 0; i < s.length(); ++i) {
            bytes[i] = (byte)s.charAt(i);
        }
        while (i < bytes.length) {
            bytes[i] = 32;
            ++i;
        }
    }

    public static void putRight(byte[] bytes, CharSequence s) {
        int i;
        for (i = 0; i < bytes.length - s.length(); ++i) {
            bytes[i] = 32;
        }
        for (int j = 0; j < s.length(); ++j) {
            bytes[i] = (byte)s.charAt(j);
            ++i;
        }
    }

    public static long getLong(byte[] bytes) {
        long sign = 1L;
        int i = 0;
        while (bytes[i] == 32) {
            ++i;
        }
        if (bytes[i] == 45) {
            sign = -1L;
            ++i;
        }
        long l = 0L;
        while (i < bytes.length && bytes[i] != 32) {
            l = 10L * l + (long)bytes[i++] - 48L;
        }
        return sign * l;
    }

    public static void putLongLeft(byte[] bytes, long l) {
        long sign = l;
        if (sign < 0L) {
            l = -l;
        }
        int i = 0;
        do {
            bytes[i++] = (byte)(48L + l % 10L);
        } while ((l /= 10L) > 0L);
        if (sign < 0L) {
            bytes[i++] = 45;
        }
        ByteArrays.reverse(bytes, 0, i);
        while (i < bytes.length) {
            bytes[i] = 32;
            ++i;
        }
    }

    public static void putLongRight(byte[] bytes, long l) {
        long sign = l;
        if (sign < 0L) {
            l = -l;
        }
        int i = bytes.length - 1;
        do {
            bytes[i--] = (byte)(48L + l % 10L);
        } while ((l /= 10L) > 0L);
        if (sign < 0L) {
            bytes[i--] = 45;
        }
        while (i >= 0) {
            bytes[i] = 32;
            --i;
        }
    }

    public static long getFixed(byte[] bytes, int decimals) {
        long sign = 1L;
        int i = 0;
        while (bytes[i] == 32) {
            ++i;
        }
        if (bytes[i] == 45) {
            sign = -1L;
            ++i;
        }
        long f = 0L;
        while (i < bytes.length && bytes[i] != 46 && bytes[i] != 32) {
            f = 10L * f + (long)bytes[i++] - 48L;
        }
        if (i == bytes.length || bytes[i] != 46) {
            return sign * f * Longs.POWERS_OF_TEN[decimals];
        }
        int point = i++;
        while (i < bytes.length && bytes[i] != 32) {
            f = 10L * f + (long)bytes[i++] - 48L;
        }
        int count = i - point - 1;
        if (count > decimals) {
            return sign * f / Longs.POWERS_OF_TEN[count - decimals];
        }
        return sign * f * Longs.POWERS_OF_TEN[decimals - count];
    }

    public static void putFixedLeft(byte[] bytes, long f, int decimals) {
        long sign = f;
        if (sign < 0L) {
            f = -f;
        }
        int i = 0;
        do {
            bytes[i++] = (byte)(48L + f % 10L);
            f /= 10L;
        } while (i < decimals);
        bytes[i++] = 46;
        do {
            bytes[i++] = (byte)(48L + f % 10L);
        } while ((f /= 10L) > 0L);
        if (sign < 0L) {
            bytes[i++] = 45;
        }
        ByteArrays.reverse(bytes, 0, i);
        while (i < bytes.length) {
            bytes[i] = 32;
            ++i;
        }
    }

    public static void putFixedRight(byte[] bytes, long f, int decimals) {
        long sign = f;
        if (sign < 0L) {
            f = -f;
        }
        int i = bytes.length - 1;
        do {
            bytes[i--] = (byte)(48L + f % 10L);
            f /= 10L;
        } while (bytes.length - 1 - i < decimals);
        bytes[i--] = 46;
        do {
            bytes[i--] = (byte)(48L + f % 10L);
        } while ((f /= 10L) > 0L);
        if (sign < 0L) {
            bytes[i--] = 45;
        }
        while (i >= 0) {
            bytes[i] = 32;
            --i;
        }
    }

    public static short packShort(CharSequence s) {
        return (short)ASCII.pack(s, 2);
    }

    public static int packInt(CharSequence s) {
        return (int)ASCII.pack(s, 4);
    }

    public static long packLong(CharSequence s) {
        return ASCII.pack(s, 8);
    }

    private static long pack(CharSequence s, int size) {
        int i;
        long l = 0L;
        for (i = 0; i < Math.min(s.length(), size); ++i) {
            l = l << 8 | (long)((byte)s.charAt(i));
        }
        while (i < size) {
            l = l << 8 | 0x20L;
            ++i;
        }
        return l;
    }

    public static void unpackShort(short s, StringBuilder b) {
        ASCII.unpack(s, 2, b);
    }

    public static String unpackShort(short s) {
        return ASCII.unpack(s, 2);
    }

    public static void unpackInt(int i, StringBuilder b) {
        ASCII.unpack(i, 4, b);
    }

    public static String unpackInt(int i) {
        return ASCII.unpack(i, 4);
    }

    public static void unpackLong(long l, StringBuilder b) {
        ASCII.unpack(l, 8, b);
    }

    public static String unpackLong(long l) {
        return ASCII.unpack(l, 8);
    }

    private static void unpack(long l, int size, StringBuilder b) {
        for (int i = 0; i < size; ++i) {
            b.append((char)(l >> 8 * (size - 1 - i) & 0xFFL));
        }
    }

    private static String unpack(long l, int size) {
        StringBuilder b = new StringBuilder(size);
        ASCII.unpack(l, size, b);
        return b.toString();
    }
}

