/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.foundation;

public class ByteArrays {
    private ByteArrays() {
    }

    public static void reverse(byte[] a) {
        ByteArrays.reverse(a, 0, a.length);
    }

    public static void reverse(byte[] a, int from, int to) {
        for (int i = 0; i < (to - from) / 2; ++i) {
            byte tmp = a[from + i];
            a[from + i] = a[to - i - 1];
            a[to - i - 1] = tmp;
        }
    }

    public static short packShort(byte[] a, byte pad) {
        return (short)ByteArrays.pack(a, pad, 2);
    }

    public static int packInt(byte[] a, byte pad) {
        return (int)ByteArrays.pack(a, pad, 4);
    }

    public static long packLong(byte[] a, byte pad) {
        return ByteArrays.pack(a, pad, 8);
    }

    private static long pack(byte[] a, byte pad, int size) {
        int i;
        long l = 0L;
        for (i = 0; i < Math.min(a.length, size); ++i) {
            l = l << 8 | (long)a[i];
        }
        while (i < size) {
            l = l << 8 | (long)pad;
            ++i;
        }
        return l;
    }

    public static void unpackShort(byte[] a, short s) {
        ByteArrays.unpack(a, s, 2);
    }

    public static byte[] unpackShort(short s) {
        return ByteArrays.unpack(s, 2);
    }

    public static void unpackInt(byte[] a, int i) {
        ByteArrays.unpack(a, i, 4);
    }

    public static byte[] unpackInt(int i) {
        return ByteArrays.unpack(i, 4);
    }

    public static void unpackLong(byte[] a, long l) {
        ByteArrays.unpack(a, l, 8);
    }

    public static byte[] unpackLong(long l) {
        return ByteArrays.unpack(l, 8);
    }

    private static void unpack(byte[] a, long l, int size) {
        for (int i = 0; i < Math.min(a.length, size); ++i) {
            a[i] = (byte)(l >> 8 * (size - 1 - i) & 0xFFL);
        }
    }

    private static byte[] unpack(long l, int size) {
        byte[] a = new byte[size];
        ByteArrays.unpack(a, l, size);
        return a;
    }
}

