/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.nassau.soupbintcp;

import com.paritytrading.nassau.soupbintcp.SoupBinTCPException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

class DataTypes {
    private static final byte SPACE = 32;

    DataTypes() {
    }

    static String getAlphanumeric(ByteBuffer buffer, int length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    static long getNumeric(ByteBuffer buffer, int length) throws IOException {
        String alphanumeric = DataTypes.getAlphanumeric(buffer, length).trim();
        try {
            long value = Long.parseLong(alphanumeric);
            if (value < 0L) {
                throw new SoupBinTCPException("Negative numeric: " + alphanumeric);
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new SoupBinTCPException("Malformed numeric: " + alphanumeric);
        }
    }

    static void putAlphanumericPadLeft(ByteBuffer buffer, String value, int length) {
        int i;
        byte[] bytes = value.getBytes(StandardCharsets.US_ASCII);
        for (i = 0; i < length - bytes.length; ++i) {
            buffer.put((byte)32);
        }
        for (i = 0; i < bytes.length - length; ++i) {
        }
        while (i < bytes.length) {
            buffer.put(bytes[i++]);
        }
    }

    static void putAlphanumericPadRight(ByteBuffer buffer, String value, int length) {
        int i;
        byte[] bytes = value.getBytes(StandardCharsets.US_ASCII);
        for (i = 0; i < Math.min(bytes.length, length); ++i) {
            buffer.put(bytes[i]);
        }
        while (i < length) {
            buffer.put((byte)32);
            ++i;
        }
    }

    static void putNumeric(ByteBuffer buffer, long value, int length) {
        DataTypes.putAlphanumericPadLeft(buffer, Long.toString(value), length);
    }
}

