/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.nassau.soupbintcp;

import com.paritytrading.nassau.soupbintcp.DataTypes;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SoupBinTCP {
    public static final byte LOGIN_REJECT_CODE_NOT_AUTHORIZED = 65;
    public static final byte LOGIN_REJECT_CODE_SESSION_NOT_AVAILABLE = 83;

    private SoupBinTCP() {
    }

    public static class LoginRequest {
        public String username;
        public String password;
        public String requestedSession;
        public long requestedSequenceNumber;

        public LoginRequest() {
        }

        public LoginRequest(String username, String password, String requestedSession, long requestedSequenceNumber) {
            this.username = username;
            this.password = password;
            this.requestedSession = requestedSession;
            this.requestedSequenceNumber = requestedSequenceNumber;
        }

        void get(ByteBuffer buffer) throws IOException {
            this.username = DataTypes.getAlphanumeric(buffer, 6);
            this.password = DataTypes.getAlphanumeric(buffer, 10);
            this.requestedSession = DataTypes.getAlphanumeric(buffer, 10);
            this.requestedSequenceNumber = DataTypes.getNumeric(buffer, 20);
        }

        void put(ByteBuffer buffer) {
            DataTypes.putAlphanumericPadRight(buffer, this.username, 6);
            DataTypes.putAlphanumericPadRight(buffer, this.password, 10);
            DataTypes.putAlphanumericPadLeft(buffer, this.requestedSession, 10);
            DataTypes.putNumeric(buffer, this.requestedSequenceNumber, 20);
        }
    }

    public static class LoginRejected {
        public byte rejectReasonCode;

        public LoginRejected() {
        }

        public LoginRejected(byte rejectReasonCode) {
            this.rejectReasonCode = rejectReasonCode;
        }

        void get(ByteBuffer buffer) {
            this.rejectReasonCode = buffer.get();
        }

        void put(ByteBuffer buffer) {
            buffer.put(this.rejectReasonCode);
        }
    }

    public static class LoginAccepted {
        public String session;
        public long sequenceNumber;

        public LoginAccepted() {
        }

        public LoginAccepted(String session, long sequenceNumber) {
            this.session = session;
            this.sequenceNumber = sequenceNumber;
        }

        void get(ByteBuffer buffer) throws IOException {
            this.session = DataTypes.getAlphanumeric(buffer, 10);
            this.sequenceNumber = DataTypes.getNumeric(buffer, 20);
        }

        void put(ByteBuffer buffer) {
            DataTypes.putAlphanumericPadLeft(buffer, this.session, 10);
            DataTypes.putNumeric(buffer, this.sequenceNumber, 20);
        }
    }
}

