/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.nassau.soupbintcp;

import com.paritytrading.nassau.MessageListener;
import com.paritytrading.nassau.soupbintcp.Packets;
import com.paritytrading.nassau.soupbintcp.SoupBinTCP;
import com.paritytrading.nassau.soupbintcp.SoupBinTCPClientStatusListener;
import com.paritytrading.nassau.soupbintcp.SoupBinTCPSession;
import com.paritytrading.nassau.util.Clock;
import com.paritytrading.nassau.util.SystemClock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class SoupBinTCPClient
extends SoupBinTCPSession {
    private static final int MIN_MAX_PAYLOAD_LENGTH = 30;
    private SoupBinTCP.LoginAccepted loginAccepted = new SoupBinTCP.LoginAccepted();
    private SoupBinTCP.LoginRejected loginRejected = new SoupBinTCP.LoginRejected();
    private MessageListener listener;
    private SoupBinTCPClientStatusListener statusListener;

    public SoupBinTCPClient(SocketChannel channel, MessageListener listener, SoupBinTCPClientStatusListener statusListener) {
        this(SystemClock.INSTANCE, channel, 65534, listener, statusListener);
    }

    public SoupBinTCPClient(SocketChannel channel, int maxPayloadLength, MessageListener listener, SoupBinTCPClientStatusListener statusListener) {
        this(SystemClock.INSTANCE, channel, maxPayloadLength, listener, statusListener);
    }

    public SoupBinTCPClient(Clock clock, SocketChannel channel, int maxPayloadLength, MessageListener listener, SoupBinTCPClientStatusListener statusListener) {
        super(clock, channel, Math.max(30, maxPayloadLength), (byte)82);
        this.listener = listener;
        this.statusListener = statusListener;
    }

    public void login(SoupBinTCP.LoginRequest payload) throws IOException {
        this.txPayload.clear();
        payload.put(this.txPayload);
        this.txPayload.flip();
        this.send((byte)76, this.txPayload);
    }

    public void logout() throws IOException {
        this.send((byte)79);
    }

    public void send(ByteBuffer buffer) throws IOException {
        this.send((byte)85, buffer);
    }

    @Override
    protected void heartbeatTimeout() throws IOException {
        this.statusListener.heartbeatTimeout(this);
    }

    @Override
    protected void packet(byte packetType, ByteBuffer payload) throws IOException {
        switch (packetType) {
            case 43: {
                break;
            }
            case 65: {
                this.loginAccepted.get(payload);
                this.statusListener.loginAccepted(this, this.loginAccepted);
                break;
            }
            case 74: {
                this.loginRejected.get(payload);
                this.statusListener.loginRejected(this, this.loginRejected);
                break;
            }
            case 83: {
                this.listener.message(payload);
                break;
            }
            case 72: {
                break;
            }
            case 90: {
                this.statusListener.endOfSession(this);
                break;
            }
            default: {
                Packets.unexpectedPacketType(packetType);
            }
        }
    }
}

