/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.parity.client;

import com.paritytrading.nassau.soupbintcp.SoupBinTCP;
import com.paritytrading.nassau.soupbintcp.SoupBinTCPClient;
import com.paritytrading.nassau.soupbintcp.SoupBinTCPClientStatusListener;
import com.paritytrading.parity.net.poe.POE;
import com.paritytrading.parity.net.poe.POEClientListener;
import com.paritytrading.parity.net.poe.POEClientParser;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class OrderEntry
implements Closeable {
    private ByteBuffer txBuffer = ByteBuffer.allocate(34);
    private Selector selector;
    private SoupBinTCPClient transport;
    private volatile boolean closed;
    private Object txLock;

    private OrderEntry(Selector selector, SocketChannel channel, POEClientListener listener) {
        this.selector = selector;
        this.transport = new SoupBinTCPClient(channel, 50, new POEClientParser(listener), new StatusListener());
        this.closed = false;
        this.txLock = new Object();
        new Thread(new Receiver()).start();
    }

    public static OrderEntry open(InetSocketAddress address, POEClientListener listener) throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.connect(address);
        channel.configureBlocking(false);
        Selector selector = Selector.open();
        channel.register(selector, 1);
        return new OrderEntry(selector, channel, listener);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public SoupBinTCPClient getTransport() {
        return this.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(POE.InboundMessage message) throws IOException {
        this.txBuffer.clear();
        message.put(this.txBuffer);
        this.txBuffer.flip();
        Object object = this.txLock;
        synchronized (object) {
            this.transport.send(this.txBuffer);
        }
    }

    private class Receiver
    implements Runnable {
        private static final long TIMEOUT_MILLIS = 100L;

        private Receiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!OrderEntry.this.closed) {
                    int numKeys = OrderEntry.this.selector.select(100L);
                    if (numKeys > 0) {
                        if (OrderEntry.this.transport.receive() < 0) break;
                        OrderEntry.this.selector.selectedKeys().clear();
                    }
                    Object object = OrderEntry.this.txLock;
                    synchronized (object) {
                        OrderEntry.this.transport.keepAlive();
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                OrderEntry.this.transport.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                OrderEntry.this.selector.close();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class StatusListener
    implements SoupBinTCPClientStatusListener {
        private StatusListener() {
        }

        @Override
        public void heartbeatTimeout(SoupBinTCPClient session) {
            OrderEntry.this.close();
        }

        @Override
        public void loginAccepted(SoupBinTCPClient session, SoupBinTCP.LoginAccepted payload) {
        }

        @Override
        public void loginRejected(SoupBinTCPClient session, SoupBinTCP.LoginRejected payload) {
            OrderEntry.this.close();
        }

        @Override
        public void endOfSession(SoupBinTCPClient session) {
        }
    }
}

