/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.parity.client.command;

import com.paritytrading.foundation.ASCII;
import com.paritytrading.parity.client.TerminalClient;
import com.paritytrading.parity.client.command.Command;
import com.paritytrading.parity.client.command.CommandException;
import com.paritytrading.parity.net.poe.POE;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Scanner;

class EnterCommand
implements Command {
    private POE.EnterOrder message = new POE.EnterOrder();

    public EnterCommand(byte side) {
        this.message.side = side;
    }

    @Override
    public void execute(TerminalClient client, Scanner arguments) throws CommandException, IOException {
        try {
            long quantity = arguments.nextInt();
            long instrument = ASCII.packLong(arguments.next());
            long price = (int)(arguments.nextDouble() * 10000.0);
            if (arguments.hasNext()) {
                throw new CommandException();
            }
            this.execute(client, quantity, instrument, price);
        }
        catch (NoSuchElementException e) {
            throw new CommandException();
        }
    }

    private void execute(TerminalClient client, long quantity, long instrument, long price) throws IOException {
        this.message.orderId = client.getOrderIdGenerator().next();
        this.message.quantity = quantity;
        this.message.instrument = instrument;
        this.message.price = price;
        client.getOrderEntry().send(this.message);
        client.printf("\nOrder ID\n----------------\n%s\n\n", this.message.orderId);
    }

    @Override
    public String getName() {
        return this.message.side == 66 ? "buy" : "sell";
    }

    @Override
    public String getDescription() {
        return "Enter a " + this.getName() + " order";
    }

    @Override
    public String getUsage() {
        return this.getName() + " <quantity> <instrument> <price>";
    }
}

