/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.parity.client.command;

import com.paritytrading.parity.client.TerminalClient;
import com.paritytrading.parity.client.command.Command;
import com.paritytrading.parity.client.command.CommandException;
import com.paritytrading.parity.client.command.Commands;
import java.util.Scanner;

class HelpCommand
implements Command {
    HelpCommand() {
    }

    @Override
    public void execute(TerminalClient client, Scanner arguments) throws CommandException {
        if (arguments.hasNext()) {
            Command command = Commands.find(arguments.next());
            if (arguments.hasNext()) {
                throw new CommandException();
            }
            if (command != null) {
                this.displayCommandHelp(client, command);
            } else {
                this.displayGeneralHelp(client);
            }
        } else {
            this.displayGeneralHelp(client);
        }
    }

    private void displayGeneralHelp(TerminalClient client) {
        client.printf("Commands:\n", new Object[0]);
        int maxCommandNameLength = this.calculateMaxCommandNameLength();
        for (Command command : Commands.all()) {
            client.printf("  %-" + maxCommandNameLength + "s  %s\n", command.getName(), command.getDescription());
        }
        client.printf("\nType 'help <command>' for command specific help.\n", new Object[0]);
    }

    private void displayCommandHelp(TerminalClient client, Command command) {
        client.printf("Usage: %s\n\n  %s\n\n", command.getUsage(), command.getDescription());
    }

    private int calculateMaxCommandNameLength() {
        return Commands.all().collectInt(c -> c.getName().length()).max();
    }

    @Override
    public String getName() {
        return "help";
    }

    @Override
    public String getDescription() {
        return "Display the help";
    }

    @Override
    public String getUsage() {
        return "help [command]";
    }
}

