/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.parity.client.event;

import com.paritytrading.foundation.ASCII;
import com.paritytrading.parity.client.TerminalClient;
import com.paritytrading.parity.client.event.Event;
import com.paritytrading.parity.util.Timestamps;

public class Order {
    public static final String HEADER = "Timestamp    Order ID         S Inst     Quantity   Price\n------------ ---------------- - -------- ---------- ---------";
    private long timestamp;
    private String orderId;
    private byte side;
    private long instrument;
    private long quantity;
    private long price;
    private long orderNumber;

    public Order(Event.OrderAccepted event) {
        this.timestamp = event.timestamp;
        this.orderId = event.orderId;
        this.side = event.side;
        this.instrument = event.instrument;
        this.quantity = event.quantity;
        this.price = event.price;
        this.orderNumber = event.orderNumber;
    }

    public void apply(Event.OrderExecuted event) {
        this.quantity -= event.quantity;
    }

    public void apply(Event.OrderCanceled event) {
        this.quantity -= event.canceledQuantity;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte getSide() {
        return this.side;
    }

    public long getInstrument() {
        return this.instrument;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public String format() {
        return String.format(TerminalClient.LOCALE, "%12s %16s %c %8s %10d %9.2f", Timestamps.format(this.timestamp / 1000000L), this.orderId, this.side, ASCII.unpackLong(this.instrument), this.quantity, (double)this.price / 10000.0);
    }
}

