/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.parity.client.event;

import com.paritytrading.parity.client.event.DefaultEventVisitor;
import com.paritytrading.parity.client.event.Event;
import com.paritytrading.parity.client.event.Events;
import com.paritytrading.parity.client.event.Order;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.factory.Maps;

public class Orders
extends DefaultEventVisitor {
    private MutableMap<String, Order> orders = Maps.mutable.with();

    private Orders() {
    }

    public static ImmutableList<Order> collect(Events events) {
        Orders visitor = new Orders();
        events.accept(visitor);
        return visitor.getEvents();
    }

    private ImmutableList<Order> getEvents() {
        return this.orders.valuesView().toSortedList((a, b) -> Long.compare(a.getTimestamp(), b.getTimestamp())).toImmutable();
    }

    @Override
    public void visit(Event.OrderAccepted event) {
        this.orders.put(event.orderId, new Order(event));
    }

    @Override
    public void visit(Event.OrderExecuted event) {
        Order order = (Order)this.orders.get(event.orderId);
        if (order == null) {
            return;
        }
        order.apply(event);
        if (order.getQuantity() <= 0L) {
            this.orders.remove(event.orderId);
        }
    }

    @Override
    public void visit(Event.OrderCanceled event) {
        Order order = (Order)this.orders.get(event.orderId);
        if (order == null) {
            return;
        }
        order.apply(event);
        if (order.getQuantity() <= 0L) {
            this.orders.remove(event.orderId);
        }
    }
}

