/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.parity.client.event;

import com.paritytrading.foundation.ASCII;
import com.paritytrading.parity.client.TerminalClient;
import com.paritytrading.parity.client.event.Event;
import com.paritytrading.parity.client.event.Order;
import com.paritytrading.parity.util.Timestamps;

public class Trade {
    public static final String HEADER = "Timestamp    Order ID         S Inst     Quantity   Price\n------------ ---------------- - -------- ---------- ---------";
    private long timestamp;
    private Order order;
    private long quantity;
    private long price;

    public Trade(Order order, Event.OrderExecuted event) {
        this.timestamp = event.timestamp;
        this.order = order;
        this.quantity = event.quantity;
        this.price = event.price;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String format() {
        return String.format(TerminalClient.LOCALE, "%12s %16s %c %8s %10d %9.2f", Timestamps.format(this.timestamp / 1000000L), this.order.getOrderId(), this.order.getSide(), ASCII.unpackLong(this.order.getInstrument()), this.quantity, (double)this.price / 10000.0);
    }
}

