/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.parity.client.event;

import com.paritytrading.parity.client.event.DefaultEventVisitor;
import com.paritytrading.parity.client.event.Event;
import com.paritytrading.parity.client.event.Events;
import com.paritytrading.parity.client.event.Order;
import com.paritytrading.parity.client.event.Trade;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.collections.impl.factory.Multimaps;

public class Trades
extends DefaultEventVisitor {
    private MutableMap<String, Order> orders = Maps.mutable.with();
    private MutableBagMultimap<Long, Trade> trades;

    private Trades() {
        this.trades = Multimaps.mutable.bag.with();
    }

    public static ImmutableList<Trade> collect(Events events) {
        Trades visitor = new Trades();
        events.accept(visitor);
        return visitor.getEvents();
    }

    private ImmutableList<Trade> getEvents() {
        return this.trades.valuesView().toSortedList((a, b) -> Long.compare(a.getTimestamp(), b.getTimestamp())).toImmutable();
    }

    @Override
    public void visit(Event.OrderAccepted event) {
        this.orders.put(event.orderId, new Order(event));
    }

    @Override
    public void visit(Event.OrderExecuted event) {
        Order order = (Order)this.orders.get(event.orderId);
        if (order == null) {
            return;
        }
        this.trades.put(event.matchNumber, new Trade(order, event));
    }

    @Override
    public void visit(Event.BrokenTrade event) {
        this.trades.removeAll(event.matchNumber);
    }
}

