/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.parity.net.poe;

import com.paritytrading.parity.net.ProtocolMessage;
import com.paritytrading.parity.net.poe.ByteBuffers;
import java.nio.ByteBuffer;

public class POE {
    public static final int MAX_INBOUND_MESSAGE_LENGTH = 34;
    public static final int MAX_OUTBOUND_MESSAGE_LENGTH = 50;
    public static final byte BUY = 66;
    public static final byte SELL = 83;
    public static final byte ORDER_REJECT_REASON_UNKNOWN_INSTRUMENT = 73;
    public static final byte LIQUIDITY_FLAG_ADDED_LIQUIDITY = 65;
    public static final byte LIQUIDITY_FLAG_REMOVED_LIQUIDITY = 82;
    public static final byte ORDER_CANCEL_REASON_REQUEST = 82;
    public static final byte ORDER_CANCEL_REASON_SUPERVISORY = 83;
    public static final byte BROKEN_TRADE_REASON_CONSENT = 67;
    public static final byte BROKEN_TRADE_REASON_SUPERVISORY = 83;
    private static final byte ORDER_ID_LENGTH = 16;
    static final byte MESSAGE_TYPE_ENTER_ORDER = 69;
    static final byte MESSAGE_TYPE_CANCEL_ORDER = 88;
    static final byte MESSAGE_TYPE_ORDER_ACCEPTED = 65;
    static final byte MESSAGE_TYPE_ORDER_REJECTED = 82;
    static final byte MESSAGE_TYPE_ORDER_EXECUTED = 69;
    static final byte MESSAGE_TYPE_ORDER_CANCELED = 88;
    static final byte MESSAGE_TYPE_BROKEN_TRADE = 66;

    private POE() {
    }

    public static class BrokenTrade
    implements OutboundMessage {
        public long timestamp;
        public String orderId;
        public long matchNumber;
        public byte reason;

        @Override
        public void get(ByteBuffer buffer) {
            this.timestamp = buffer.getLong();
            this.orderId = ByteBuffers.getString(buffer, 16);
            this.matchNumber = com.paritytrading.foundation.ByteBuffers.getUnsignedInt(buffer);
            this.reason = buffer.get();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)66);
            buffer.putLong(this.timestamp);
            ByteBuffers.putString(buffer, this.orderId, 16);
            com.paritytrading.foundation.ByteBuffers.putUnsignedInt(buffer, this.matchNumber);
            buffer.put(this.reason);
        }
    }

    public static class OrderCanceled
    implements OutboundMessage {
        public long timestamp;
        public String orderId;
        public long canceledQuantity;
        public byte reason;

        @Override
        public void get(ByteBuffer buffer) {
            this.timestamp = buffer.getLong();
            this.orderId = ByteBuffers.getString(buffer, 16);
            this.canceledQuantity = com.paritytrading.foundation.ByteBuffers.getUnsignedInt(buffer);
            this.reason = buffer.get();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)88);
            buffer.putLong(this.timestamp);
            ByteBuffers.putString(buffer, this.orderId, 16);
            com.paritytrading.foundation.ByteBuffers.putUnsignedInt(buffer, this.canceledQuantity);
            buffer.put(this.reason);
        }
    }

    public static class OrderExecuted
    implements OutboundMessage {
        public long timestamp;
        public String orderId;
        public long quantity;
        public long price;
        public byte liquidityFlag;
        public long matchNumber;

        @Override
        public void get(ByteBuffer buffer) {
            this.timestamp = buffer.getLong();
            this.orderId = ByteBuffers.getString(buffer, 16);
            this.quantity = com.paritytrading.foundation.ByteBuffers.getUnsignedInt(buffer);
            this.price = com.paritytrading.foundation.ByteBuffers.getUnsignedInt(buffer);
            this.liquidityFlag = buffer.get();
            this.matchNumber = com.paritytrading.foundation.ByteBuffers.getUnsignedInt(buffer);
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)69);
            buffer.putLong(this.timestamp);
            ByteBuffers.putString(buffer, this.orderId, 16);
            com.paritytrading.foundation.ByteBuffers.putUnsignedInt(buffer, this.quantity);
            com.paritytrading.foundation.ByteBuffers.putUnsignedInt(buffer, this.price);
            buffer.put(this.liquidityFlag);
            com.paritytrading.foundation.ByteBuffers.putUnsignedInt(buffer, this.matchNumber);
        }
    }

    public static class OrderRejected
    implements OutboundMessage {
        public long timestamp;
        public String orderId;
        public byte reason;

        @Override
        public void get(ByteBuffer buffer) {
            this.timestamp = buffer.getLong();
            this.orderId = ByteBuffers.getString(buffer, 16);
            this.reason = buffer.get();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)82);
            buffer.putLong(this.timestamp);
            ByteBuffers.putString(buffer, this.orderId, 16);
            buffer.put(this.reason);
        }
    }

    public static class OrderAccepted
    implements OutboundMessage {
        public long timestamp;
        public String orderId;
        public byte side;
        public long instrument;
        public long quantity;
        public long price;
        public long orderNumber;

        @Override
        public void get(ByteBuffer buffer) {
            this.timestamp = buffer.getLong();
            this.orderId = ByteBuffers.getString(buffer, 16);
            this.side = buffer.get();
            this.instrument = buffer.getLong();
            this.quantity = com.paritytrading.foundation.ByteBuffers.getUnsignedInt(buffer);
            this.price = com.paritytrading.foundation.ByteBuffers.getUnsignedInt(buffer);
            this.orderNumber = buffer.getLong();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)65);
            buffer.putLong(this.timestamp);
            ByteBuffers.putString(buffer, this.orderId, 16);
            buffer.put(this.side);
            buffer.putLong(this.instrument);
            com.paritytrading.foundation.ByteBuffers.putUnsignedInt(buffer, this.quantity);
            com.paritytrading.foundation.ByteBuffers.putUnsignedInt(buffer, this.price);
            buffer.putLong(this.orderNumber);
        }
    }

    public static interface OutboundMessage
    extends Message {
    }

    public static class CancelOrder
    implements InboundMessage {
        public String orderId;
        public long quantity;

        @Override
        public void get(ByteBuffer buffer) {
            this.orderId = ByteBuffers.getString(buffer, 16);
            this.quantity = com.paritytrading.foundation.ByteBuffers.getUnsignedInt(buffer);
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)88);
            ByteBuffers.putString(buffer, this.orderId, 16);
            com.paritytrading.foundation.ByteBuffers.putUnsignedInt(buffer, this.quantity);
        }
    }

    public static class EnterOrder
    implements InboundMessage {
        public String orderId;
        public byte side;
        public long instrument;
        public long quantity;
        public long price;

        @Override
        public void get(ByteBuffer buffer) {
            this.orderId = ByteBuffers.getString(buffer, 16);
            this.side = buffer.get();
            this.instrument = buffer.getLong();
            this.quantity = com.paritytrading.foundation.ByteBuffers.getUnsignedInt(buffer);
            this.price = com.paritytrading.foundation.ByteBuffers.getUnsignedInt(buffer);
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)69);
            ByteBuffers.putString(buffer, this.orderId, 16);
            buffer.put(this.side);
            buffer.putLong(this.instrument);
            com.paritytrading.foundation.ByteBuffers.putUnsignedInt(buffer, this.quantity);
            com.paritytrading.foundation.ByteBuffers.putUnsignedInt(buffer, this.price);
        }
    }

    public static interface InboundMessage
    extends Message {
    }

    public static interface Message
    extends ProtocolMessage {
    }
}

