/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.parity.net.poe;

import com.paritytrading.nassau.MessageListener;
import com.paritytrading.parity.net.poe.POE;
import com.paritytrading.parity.net.poe.POEClientListener;
import com.paritytrading.parity.net.poe.POEException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class POEClientParser
implements MessageListener {
    private POE.OrderAccepted orderAccepted = new POE.OrderAccepted();
    private POE.OrderRejected orderRejected = new POE.OrderRejected();
    private POE.OrderExecuted orderExecuted = new POE.OrderExecuted();
    private POE.OrderCanceled orderCanceled = new POE.OrderCanceled();
    private POE.BrokenTrade brokenTrade = new POE.BrokenTrade();
    private POEClientListener listener;

    public POEClientParser(POEClientListener listener) {
        this.listener = listener;
    }

    @Override
    public void message(ByteBuffer buffer) throws IOException {
        byte messageType = buffer.get();
        switch (messageType) {
            case 65: {
                this.orderAccepted.get(buffer);
                this.listener.orderAccepted(this.orderAccepted);
                break;
            }
            case 82: {
                this.orderRejected.get(buffer);
                this.listener.orderRejected(this.orderRejected);
                break;
            }
            case 69: {
                this.orderExecuted.get(buffer);
                this.listener.orderExecuted(this.orderExecuted);
                break;
            }
            case 88: {
                this.orderCanceled.get(buffer);
                this.listener.orderCanceled(this.orderCanceled);
                break;
            }
            case 66: {
                this.brokenTrade.get(buffer);
                this.listener.brokenTrade(this.brokenTrade);
                break;
            }
            default: {
                throw new POEException("Unknown message type: " + (char)messageType);
            }
        }
    }
}

