/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.bag.UnsortedBag;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.block.procedure.checked.CheckedObjectIntProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImmutableBagSerializationProxy<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private UnsortedBag<T> bag;

    public ImmutableBagSerializationProxy() {
    }

    ImmutableBagSerializationProxy(UnsortedBag<T> bag) {
        this.bag = bag;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.bag.sizeDistinct());
        try {
            this.bag.forEachWithOccurrences(new CheckedObjectIntProcedure<T>(){

                @Override
                public void safeValue(T object, int index) throws IOException {
                    out.writeObject(object);
                    out.writeInt(index);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        HashBag<Object> deserializedBag = new HashBag<Object>(size);
        for (int i = 0; i < size; ++i) {
            deserializedBag.addOccurrences(in.readObject(), in.readInt());
        }
        this.bag = deserializedBag;
    }

    protected Object readResolve() {
        return this.bag.toImmutable();
    }
}

