/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.bag.primitive.LongBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedLongIntProcedure;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableLongHashBag
implements ImmutableLongBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongBag delegate;

    private ImmutableLongHashBag(long[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = LongHashBag.newBagWith(newElements);
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use LongBags.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableLongHashBag newBagWith(long ... elements) {
        return new ImmutableLongHashBag(elements);
    }

    @Override
    public ImmutableLongBag newWith(long element) {
        return LongHashBag.newBag(this.delegate).with(element).toImmutable();
    }

    @Override
    public ImmutableLongBag newWithout(long element) {
        LongHashBag hashBag = LongHashBag.newBag(this.delegate);
        hashBag.remove(element);
        return hashBag.toImmutable();
    }

    @Override
    public ImmutableLongBag newWithAll(LongIterable elements) {
        LongHashBag bag = LongHashBag.newBag(this.delegate);
        bag.addAll(elements);
        return bag.toImmutable();
    }

    @Override
    public ImmutableLongBag newWithoutAll(LongIterable elements) {
        LongHashBag bag = LongHashBag.newBag(this.delegate);
        bag.removeAll(elements);
        return bag.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public boolean contains(long value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(LongIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(long ... elements) {
        return this.delegate.containsAll(elements);
    }

    @Override
    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(LongProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public ImmutableLongBag select(LongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableLongBag reject(LongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(LongToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public MutableLongList toList() {
        return this.delegate.toList();
    }

    @Override
    public int sizeDistinct() {
        return this.delegate.sizeDistinct();
    }

    @Override
    public int occurrencesOf(long item) {
        return this.delegate.occurrencesOf(item);
    }

    @Override
    public void forEachWithOccurrences(LongIntProcedure longIntProcedure) {
        this.delegate.forEachWithOccurrences(longIntProcedure);
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public int count(LongPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public long min() {
        return this.delegate.min();
    }

    @Override
    public long max() {
        return this.delegate.max();
    }

    @Override
    public long maxIfEmpty(long defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public long minIfEmpty(long defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public long[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableLongList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public MutableLongSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableLongBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public ImmutableLongBag toImmutable() {
        return this;
    }

    @Override
    public LazyLongIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public long[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public LongIterator longIterator() {
        return new UnmodifiableLongIterator(this.delegate.longIterator());
    }

    private Object writeReplace() {
        return new ImmutableLongBagSerializationProxy(this);
    }

    protected static class ImmutableLongBagSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private LongBag bag;

        public ImmutableLongBagSerializationProxy() {
        }

        protected ImmutableLongBagSerializationProxy(LongBag bag) {
            this.bag = bag;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.bag.sizeDistinct());
            try {
                this.bag.forEachWithOccurrences(new CheckedLongIntProcedure(){

                    public void safeValue(long item, int count) throws IOException {
                        out.writeLong(item);
                        out.writeInt(count);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            LongHashBag deserializedBag = new LongHashBag();
            for (int i = 0; i < size; ++i) {
                deserializedBag.addOccurrences(in.readLong(), in.readInt());
            }
            this.bag = deserializedBag;
        }

        protected Object readResolve() {
            return this.bag.toImmutable();
        }
    }
}

