/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.factory;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.impl.factory.primitive.ObjectDoubleMaps;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectDoubleHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitiveFunctions {
    private static final IntegerIsPositive INTEGER_IS_POSITIVE = new IntegerIsPositive();
    private static final UnboxNumberToInt UNBOX_NUMBER_TO_INT = new UnboxNumberToInt();
    private static final UnboxIntegerToByte UNBOX_INTEGER_TO_BYTE = new UnboxIntegerToByte();
    private static final UnboxIntegerToChar UNBOX_INTEGER_TO_CHAR = new UnboxIntegerToChar();
    private static final UnboxIntegerToInt UNBOX_INTEGER_TO_INT = new UnboxIntegerToInt();
    private static final UnboxIntegerToFloat UNBOX_INTEGER_TO_FLOAT = new UnboxIntegerToFloat();
    private static final UnboxIntegerToLong UNBOX_INTEGER_TO_LONG = new UnboxIntegerToLong();
    private static final UnboxIntegerToShort UNBOX_INTEGER_TO_SHORT = new UnboxIntegerToShort();
    private static final UnboxIntegerToDouble UNBOX_INTEGER_TO_DOUBLE = new UnboxIntegerToDouble();
    private static final UnboxDoubleToDouble UNBOX_DOUBLE_TO_DOUBLE = new UnboxDoubleToDouble();
    private static final UnboxFloatToFloat UNBOX_FLOAT_TO_FLOAT = new UnboxFloatToFloat();
    private static final UnboxNumberToFloat UNBOX_NUMBER_TO_FLOAT = new UnboxNumberToFloat();
    private static final UnboxNumberToLong UNBOX_NUMBER_TO_LONG = new UnboxNumberToLong();
    private static final UnboxNumberToDouble UNBOX_NUMBER_TO_DOUBLE = new UnboxNumberToDouble();

    private PrimitiveFunctions() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static BooleanFunction<Integer> integerIsPositive() {
        return INTEGER_IS_POSITIVE;
    }

    public static IntFunction<Number> unboxNumberToInt() {
        return UNBOX_NUMBER_TO_INT;
    }

    public static ByteFunction<Integer> unboxIntegerToByte() {
        return UNBOX_INTEGER_TO_BYTE;
    }

    public static CharFunction<Integer> unboxIntegerToChar() {
        return UNBOX_INTEGER_TO_CHAR;
    }

    public static IntFunction<Integer> unboxIntegerToInt() {
        return UNBOX_INTEGER_TO_INT;
    }

    public static FloatFunction<Number> unboxNumberToFloat() {
        return UNBOX_NUMBER_TO_FLOAT;
    }

    public static LongFunction<Number> unboxNumberToLong() {
        return UNBOX_NUMBER_TO_LONG;
    }

    public static DoubleFunction<Number> unboxNumberToDouble() {
        return UNBOX_NUMBER_TO_DOUBLE;
    }

    public static FloatFunction<Integer> unboxIntegerToFloat() {
        return UNBOX_INTEGER_TO_FLOAT;
    }

    public static LongFunction<Integer> unboxIntegerToLong() {
        return UNBOX_INTEGER_TO_LONG;
    }

    public static ShortFunction<Integer> unboxIntegerToShort() {
        return UNBOX_INTEGER_TO_SHORT;
    }

    public static DoubleFunction<Integer> unboxIntegerToDouble() {
        return UNBOX_INTEGER_TO_DOUBLE;
    }

    public static DoubleFunction<Double> unboxDoubleToDouble() {
        return UNBOX_DOUBLE_TO_DOUBLE;
    }

    public static FloatFunction<Float> unboxFloatToFloat() {
        return UNBOX_FLOAT_TO_FLOAT;
    }

    public static <T, V> Function2<ObjectLongHashMap<V>, T, ObjectLongHashMap<V>> sumByIntFunction(final Function<T, V> groupBy, final IntFunction<? super T> function) {
        return new Function2<ObjectLongHashMap<V>, T, ObjectLongHashMap<V>>(){
            private static final long serialVersionUID = 1L;

            @Override
            public ObjectLongHashMap<V> value(ObjectLongHashMap<V> map, T each) {
                map.addToValue(groupBy.valueOf(each), function.intValueOf(each));
                return map;
            }
        };
    }

    public static <T, V> Function2<ObjectDoubleHashMap<V>, T, ObjectDoubleHashMap<V>> sumByFloatFunction(final Function<T, V> groupBy, final FloatFunction<? super T> function) {
        return new Function2<ObjectDoubleHashMap<V>, T, ObjectDoubleHashMap<V>>(){
            private static final long serialVersionUID = 1L;
            private final MutableObjectDoubleMap<V> compensation = ObjectDoubleMaps.mutable.of();

            @Override
            public ObjectDoubleHashMap<V> value(ObjectDoubleHashMap<V> map, T each) {
                Object groupKey = groupBy.valueOf(each);
                double compensation = this.compensation.getIfAbsent(groupKey, 0.0);
                double adjustedValue = (double)function.floatValueOf(each) - compensation;
                double nextSum = map.get(groupKey) + adjustedValue;
                this.compensation.put(groupKey, nextSum - map.get(groupKey) - adjustedValue);
                map.put(groupKey, nextSum);
                return map;
            }
        };
    }

    public static <T, V> Function2<ObjectLongHashMap<V>, T, ObjectLongHashMap<V>> sumByLongFunction(final Function<T, V> groupBy, final LongFunction<? super T> function) {
        return new Function2<ObjectLongHashMap<V>, T, ObjectLongHashMap<V>>(){
            private static final long serialVersionUID = 1L;

            @Override
            public ObjectLongHashMap<V> value(ObjectLongHashMap<V> map, T each) {
                map.addToValue(groupBy.valueOf(each), function.longValueOf(each));
                return map;
            }
        };
    }

    public static <T, V> Function2<ObjectDoubleHashMap<V>, T, ObjectDoubleHashMap<V>> sumByDoubleFunction(final Function<T, V> groupBy, final DoubleFunction<? super T> function) {
        return new Function2<ObjectDoubleHashMap<V>, T, ObjectDoubleHashMap<V>>(){
            private static final long serialVersionUID = 1L;
            private final MutableObjectDoubleMap<V> compensation = ObjectDoubleMaps.mutable.of();

            @Override
            public ObjectDoubleHashMap<V> value(ObjectDoubleHashMap<V> map, T each) {
                Object groupKey = groupBy.valueOf(each);
                double compensation = this.compensation.getIfAbsent(groupKey, 0.0);
                double adjustedValue = function.doubleValueOf(each) - compensation;
                double nextSum = map.get(groupKey) + adjustedValue;
                this.compensation.put(groupKey, nextSum - map.get(groupKey) - adjustedValue);
                map.put(groupKey, nextSum);
                return map;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnboxNumberToDouble
    implements DoubleFunction<Number> {
        private static final long serialVersionUID = 1L;

        private UnboxNumberToDouble() {
        }

        @Override
        public double doubleValueOf(Number number) {
            return number.doubleValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnboxNumberToLong
    implements LongFunction<Number> {
        private static final long serialVersionUID = 1L;

        private UnboxNumberToLong() {
        }

        @Override
        public long longValueOf(Number number) {
            return number.longValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnboxNumberToFloat
    implements FloatFunction<Number> {
        private static final long serialVersionUID = 1L;

        private UnboxNumberToFloat() {
        }

        @Override
        public float floatValueOf(Number number) {
            return number.floatValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnboxFloatToFloat
    implements FloatFunction<Float> {
        private static final long serialVersionUID = 1L;

        private UnboxFloatToFloat() {
        }

        @Override
        public float floatValueOf(Float aFloat) {
            return aFloat.floatValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnboxDoubleToDouble
    implements DoubleFunction<Double> {
        private static final long serialVersionUID = 1L;

        private UnboxDoubleToDouble() {
        }

        @Override
        public double doubleValueOf(Double aDouble) {
            return aDouble;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnboxIntegerToDouble
    implements DoubleFunction<Integer> {
        private static final long serialVersionUID = 1L;

        private UnboxIntegerToDouble() {
        }

        @Override
        public double doubleValueOf(Integer integer) {
            return integer.intValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnboxIntegerToShort
    implements ShortFunction<Integer> {
        private static final long serialVersionUID = 1L;

        private UnboxIntegerToShort() {
        }

        @Override
        public short shortValueOf(Integer integer) {
            return integer.shortValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnboxIntegerToLong
    implements LongFunction<Integer> {
        private static final long serialVersionUID = 1L;

        private UnboxIntegerToLong() {
        }

        @Override
        public long longValueOf(Integer integer) {
            return integer.intValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnboxIntegerToFloat
    implements FloatFunction<Integer> {
        private static final long serialVersionUID = 1L;

        private UnboxIntegerToFloat() {
        }

        @Override
        public float floatValueOf(Integer integer) {
            return integer.intValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnboxIntegerToInt
    implements IntFunction<Integer> {
        private static final long serialVersionUID = 1L;

        private UnboxIntegerToInt() {
        }

        @Override
        public int intValueOf(Integer integer) {
            return integer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnboxIntegerToChar
    implements CharFunction<Integer> {
        private static final long serialVersionUID = 1L;

        private UnboxIntegerToChar() {
        }

        @Override
        public char charValueOf(Integer integer) {
            return (char)integer.intValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnboxIntegerToByte
    implements ByteFunction<Integer> {
        private static final long serialVersionUID = 1L;

        private UnboxIntegerToByte() {
        }

        @Override
        public byte byteValueOf(Integer integer) {
            return integer.byteValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnboxNumberToInt
    implements IntFunction<Number> {
        private static final long serialVersionUID = 1L;

        private UnboxNumberToInt() {
        }

        @Override
        public int intValueOf(Number number) {
            return number.intValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerIsPositive
    implements BooleanFunction<Integer> {
        private static final long serialVersionUID = 1L;

        private IntegerIsPositive() {
        }

        @Override
        public boolean booleanValueOf(Integer integer) {
            return integer > 0;
        }
    }
}

