/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collection;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import net.jcip.annotations.GuardedBy;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectLongMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.utility.LazyIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSynchronizedRichIterable<T>
implements RichIterable<T> {
    protected final Object lock;
    @GuardedBy(value="this.lock")
    protected final RichIterable<T> delegate;

    protected AbstractSynchronizedRichIterable(RichIterable<T> delegate, Object lock) {
        if (delegate == null) {
            throw new IllegalArgumentException("Cannot create a AbstractSynchronizedRichIterable on a null collection");
        }
        this.delegate = delegate;
        this.lock = lock == null ? this : lock;
    }

    protected RichIterable<T> getDelegate() {
        return this.delegate;
    }

    protected Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.equals(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toString();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        this.each(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.forEachWithIndex(objectIntProcedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.forEachWith(procedure, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getFirst() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getLast() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.getLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAllIterable(Iterable<?> source) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.containsAllIterable(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> coll) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.containsAll(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAllArguments(Object ... elements) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.containsAllArguments(elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void each(Procedure<? super T> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Collection<T>> R select(Predicate<? super T> predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.select(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P, R extends Collection<T>> R selectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.selectWith(predicate, parameter, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Collection<T>> R reject(Predicate<? super T> predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.reject(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P, R extends Collection<T>> R rejectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.rejectWith(predicate, parameter, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super T> booleanFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectBoolean(booleanFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super T> byteFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectByte(byteFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableCharCollection> R collectChar(CharFunction<? super T> charFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectChar(charFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super T> doubleFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectDouble(doubleFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super T> floatFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectFloat(floatFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableIntCollection> R collectInt(IntFunction<? super T> intFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectInt(intFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableLongCollection> R collectLong(LongFunction<? super T> longFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectLong(longFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super T> shortFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectShort(shortFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends Collection<V>> R collect(Function<? super T, ? extends V> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collect(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P, A, R extends Collection<A>> R collectWith(Function2<? super T, ? super P, ? extends A> function, P parameter, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectWith(function, parameter, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends Collection<V>> R collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.collectIf(predicate, function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends Collection<V>> R flatCollect(Function<? super T, ? extends Iterable<V>> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.flatCollect(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T detect(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.detect(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.detectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.detectIfNone(predicate, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.detectWithIfNone(predicate, parameter, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.countWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.anySatisfyWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.allSatisfyWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.noneSatisfyWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int injectInto(int injectedValue, IntObjectToIntFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long injectInto(long injectedValue, LongObjectToLongFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<T> toSortedList(Comparator<? super T> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedList(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedList(Comparators.byFunction(function));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<T> toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> toSortedSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedSet(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedSetBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBag<T> toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedBag<T> toSortedBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedBag<T> toSortedBag(Comparator<? super T> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedBag(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V extends Comparable<? super V>> MutableSortedBag<T> toSortedBagBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedBag(Comparators.byFunction(function));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toMap(keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedMap(keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toSortedMap(comparator, keyFunction, valueFunction);
        }
    }

    @Override
    public LazyIterable<T> asLazy() {
        return LazyIterate.adapt(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T min(Comparator<? super T> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.min(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T max(Comparator<? super T> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.max(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T min() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T max() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.minBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.maxBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sumOfInt(IntFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumOfInt(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double sumOfFloat(FloatFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumOfFloat(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sumOfLong(LongFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumOfLong(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double sumOfDouble(DoubleFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumOfDouble(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> ObjectLongMap<V> sumByInt(Function<T, V> groupBy, IntFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumByInt(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> ObjectDoubleMap<V> sumByFloat(Function<T, V> groupBy, FloatFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumByFloat(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> ObjectLongMap<V> sumByLong(Function<T, V> groupBy, LongFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumByLong(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> ObjectDoubleMap<V> sumByDouble(Function<T, V> groupBy, DoubleFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.sumByDouble(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.groupBy(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.groupByEach(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.groupByUniqueKey(function, UnifiedMap.newMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends MutableMap<V, T>> R groupByUniqueKey(Function<? super T, ? extends V> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.groupByUniqueKey(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.zip(that, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.zipWithIndex(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<RichIterable<T>> chunk(int size) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.chunk(size);
        }
    }
}

