/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy;

import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.impl.Counter;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.iterator.FlatCollectIterator;
import org.eclipse.collections.impl.utility.Iterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class FlatCollectIterable<T, V>
extends AbstractLazyIterable<V> {
    private final Iterable<T> adapted;
    private final Function<? super T, ? extends Iterable<V>> function;

    public FlatCollectIterable(Iterable<T> newAdapted, Function<? super T, ? extends Iterable<V>> function) {
        this.adapted = newAdapted;
        this.function = function;
    }

    @Override
    public void each(final Procedure<? super V> procedure) {
        Iterate.forEach(this.adapted, new Procedure<T>(){

            @Override
            public void value(T each) {
                Iterate.forEach((Iterable)FlatCollectIterable.this.function.valueOf(each), procedure);
            }
        });
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        final AdaptObjectIntProcedureToProcedure innerProcedure = new AdaptObjectIntProcedureToProcedure(objectIntProcedure);
        Iterate.forEach(this.adapted, new Procedure<T>(){

            @Override
            public void value(T each) {
                Iterable iterable = (Iterable)FlatCollectIterable.this.function.valueOf(each);
                Iterate.forEach(iterable, innerProcedure);
            }
        });
    }

    @Override
    public <P> void forEachWith(final Procedure2<? super V, ? super P> procedure, final P parameter) {
        Iterate.forEach(this.adapted, new Procedure<T>(){

            @Override
            public void value(T each) {
                Iterate.forEachWith((Iterable)FlatCollectIterable.this.function.valueOf(each), procedure, parameter);
            }
        });
    }

    @Override
    public V detect(final Predicate<? super V> predicate) {
        final Object[] result = new Object[1];
        Iterate.detect(this.adapted, new Predicate<T>(){

            @Override
            public boolean accept(T each) {
                Iterable iterable = (Iterable)FlatCollectIterable.this.function.valueOf(each);
                return Iterate.anySatisfy(iterable, new Predicate<V>(){

                    @Override
                    public boolean accept(V each) {
                        if (predicate.accept(each)) {
                            result[0] = each;
                            return true;
                        }
                        return false;
                    }
                });
            }
        });
        return (V)result[0];
    }

    @Override
    public boolean anySatisfy(final Predicate<? super V> predicate) {
        return Iterate.anySatisfy(this.adapted, new Predicate<T>(){

            @Override
            public boolean accept(T each) {
                return Iterate.anySatisfy((Iterable)FlatCollectIterable.this.function.valueOf(each), predicate);
            }
        });
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.anySatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public boolean allSatisfy(final Predicate<? super V> predicate) {
        return Iterate.allSatisfy(this.adapted, new Predicate<T>(){

            @Override
            public boolean accept(T each) {
                return Iterate.allSatisfy((Iterable)FlatCollectIterable.this.function.valueOf(each), predicate);
            }
        });
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.allSatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public boolean noneSatisfy(final Predicate<? super V> predicate) {
        return Iterate.noneSatisfy(this.adapted, new Predicate<T>(){

            @Override
            public boolean accept(T each) {
                return Iterate.anySatisfy((Iterable)FlatCollectIterable.this.function.valueOf(each), predicate);
            }
        });
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.noneSatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public Iterator<V> iterator() {
        return new FlatCollectIterator(this.adapted, this.function);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AdaptObjectIntProcedureToProcedure<V>
    implements Procedure<V> {
        private static final long serialVersionUID = 1L;
        private final Counter index;
        private final ObjectIntProcedure<? super V> objectIntProcedure;

        private AdaptObjectIntProcedureToProcedure(ObjectIntProcedure<? super V> objectIntProcedure) {
            this.objectIntProcedure = objectIntProcedure;
            this.index = new Counter();
        }

        @Override
        public void value(V each) {
            this.objectIntProcedure.value(each, this.index.getCount());
            this.index.increment();
        }
    }
}

