/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel;

import java.util.Comparator;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.impl.block.procedure.CountProcedure;
import org.eclipse.collections.impl.block.procedure.DoubleSumResultHolder;
import org.eclipse.collections.impl.block.procedure.MaxByProcedure;
import org.eclipse.collections.impl.block.procedure.MaxComparatorProcedure;
import org.eclipse.collections.impl.block.procedure.MinByProcedure;
import org.eclipse.collections.impl.block.procedure.MinComparatorProcedure;
import org.eclipse.collections.impl.block.procedure.SumOfDoubleProcedure;
import org.eclipse.collections.impl.block.procedure.SumOfFloatProcedure;
import org.eclipse.collections.impl.block.procedure.SumOfIntProcedure;
import org.eclipse.collections.impl.block.procedure.SumOfLongProcedure;
import org.eclipse.collections.impl.lazy.parallel.Batch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBatch<T>
implements Batch<T> {
    @Override
    public int count(Predicate<? super T> predicate) {
        CountProcedure<T> procedure = new CountProcedure<T>(predicate);
        this.forEach(procedure);
        return procedure.getCount();
    }

    @Override
    public String makeString(final String separator) {
        final StringBuilder stringBuilder = new StringBuilder();
        this.forEach(new Procedure<T>(){

            @Override
            public void value(T each) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(separator);
                }
                stringBuilder.append(each);
            }
        });
        return stringBuilder.toString();
    }

    @Override
    public T min(Comparator<? super T> comparator) {
        MinComparatorProcedure<T> procedure = new MinComparatorProcedure<T>(comparator);
        this.forEach(procedure);
        return procedure.isVisitedAtLeastOnce() ? (T)procedure.getResult() : null;
    }

    @Override
    public T max(Comparator<? super T> comparator) {
        MaxComparatorProcedure<T> procedure = new MaxComparatorProcedure<T>(comparator);
        this.forEach(procedure);
        return procedure.isVisitedAtLeastOnce() ? (T)procedure.getResult() : null;
    }

    @Override
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        MinByProcedure<T, V> procedure = new MinByProcedure<T, V>(function);
        this.forEach(procedure);
        return procedure.isVisitedAtLeastOnce() ? (T)procedure.getResult() : null;
    }

    @Override
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        MaxByProcedure<T, V> procedure = new MaxByProcedure<T, V>(function);
        this.forEach(procedure);
        return procedure.isVisitedAtLeastOnce() ? (T)procedure.getResult() : null;
    }

    @Override
    public long sumOfInt(IntFunction<? super T> function) {
        SumOfIntProcedure<T> procedure = new SumOfIntProcedure<T>(function);
        this.forEach(procedure);
        return procedure.getResult();
    }

    @Override
    public DoubleSumResultHolder sumOfFloat(FloatFunction<? super T> function) {
        SumOfFloatProcedure<? super T> procedure = new SumOfFloatProcedure<T>(function);
        this.forEach(procedure);
        return procedure;
    }

    @Override
    public long sumOfLong(LongFunction<? super T> function) {
        SumOfLongProcedure<T> procedure = new SumOfLongProcedure<T>(function);
        this.forEach(procedure);
        return procedure.getResult();
    }

    @Override
    public DoubleSumResultHolder sumOfDouble(DoubleFunction<? super T> function) {
        SumOfDoubleProcedure<? super T> procedure = new SumOfDoubleProcedure<T>(function);
        this.forEach(procedure);
        return procedure;
    }
}

