/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.CharList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyCharIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;

public class ReverseCharIterable
extends AbstractLazyCharIterable {
    private final CharList adapted;

    public ReverseCharIterable(CharList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseCharIterable adapt(CharList charList) {
        return new ReverseCharIterable(charList);
    }

    public CharIterator charIterator() {
        return new ReverseCharIterator();
    }

    public void each(CharProcedure procedure) {
        CharIterator iterator = this.charIterator();
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public long sum() {
        return this.adapted.sum();
    }

    public char max() {
        return this.adapted.max();
    }

    public char min() {
        return this.adapted.min();
    }

    public char minIfEmpty(char defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    public char maxIfEmpty(char defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    public double average() {
        return this.adapted.average();
    }

    public double median() {
        return this.adapted.median();
    }

    public char[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    public char[] toArray() {
        char[] results = new char[this.adapted.size()];
        int index = 0;
        CharIterator iterator = this.charIterator();
        while (iterator.hasNext()) {
            results[index] = iterator.next();
            ++index;
        }
        return results;
    }

    public boolean contains(char value) {
        return this.adapted.contains(value);
    }

    public boolean containsAll(char ... source) {
        return this.adapted.containsAll(source);
    }

    public boolean containsAll(CharIterable source) {
        return this.adapted.containsAll(source);
    }

    public int size() {
        return this.adapted.size();
    }

    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    public MutableCharList toList() {
        return CharArrayList.newList(this);
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSet(this);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBag(this);
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter(this);
    }

    private class ReverseCharIterator
    implements CharIterator {
        private int currentIndex;

        private ReverseCharIterator() {
            this.currentIndex = ReverseCharIterable.this.adapted.size() - 1;
        }

        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            char next = ReverseCharIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

