/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyLongIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

public class ReverseLongIterable
extends AbstractLazyLongIterable {
    private final LongList adapted;

    public ReverseLongIterable(LongList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseLongIterable adapt(LongList longList) {
        return new ReverseLongIterable(longList);
    }

    public LongIterator longIterator() {
        return new ReverseLongIterator();
    }

    public void each(LongProcedure procedure) {
        LongIterator iterator = this.longIterator();
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public long sum() {
        return this.adapted.sum();
    }

    public long max() {
        return this.adapted.max();
    }

    public long min() {
        return this.adapted.min();
    }

    public long minIfEmpty(long defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    public long maxIfEmpty(long defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    public double average() {
        return this.adapted.average();
    }

    public double median() {
        return this.adapted.median();
    }

    public long[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    public long[] toArray() {
        long[] results = new long[this.adapted.size()];
        int index = 0;
        LongIterator iterator = this.longIterator();
        while (iterator.hasNext()) {
            results[index] = iterator.next();
            ++index;
        }
        return results;
    }

    public boolean contains(long value) {
        return this.adapted.contains(value);
    }

    public boolean containsAll(long ... source) {
        return this.adapted.containsAll(source);
    }

    public boolean containsAll(LongIterable source) {
        return this.adapted.containsAll(source);
    }

    public int size() {
        return this.adapted.size();
    }

    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    public MutableLongList toList() {
        return LongArrayList.newList(this);
    }

    public MutableLongSet toSet() {
        return LongHashSet.newSet(this);
    }

    public MutableLongBag toBag() {
        return LongHashBag.newBag(this);
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter(this);
    }

    private class ReverseLongIterator
    implements LongIterator {
        private int currentIndex;

        private ReverseLongIterator() {
            this.currentIndex = ReverseLongIterable.this.adapted.size() - 1;
        }

        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long next = ReverseLongIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

