/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.block.factory.primitive.BytePredicates;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyByteIterable;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;

public class SelectByteIterable
extends AbstractLazyByteIterable {
    private final ByteIterable delegate;
    private final BytePredicate predicate;

    public SelectByteIterable(ByteIterable delegate, BytePredicate predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public ByteIterator byteIterator() {
        return new SelectByteIterator(this.delegate, this.predicate);
    }

    public void each(ByteProcedure procedure) {
        this.delegate.forEach(new IfByteProcedure(procedure));
    }

    public int size() {
        return this.delegate.count(this.predicate);
    }

    public boolean isEmpty() {
        return !this.byteIterator().hasNext();
    }

    public boolean notEmpty() {
        return this.byteIterator().hasNext();
    }

    public int count(BytePredicate predicate) {
        CountByteProcedure countByteProcedure = new CountByteProcedure(predicate);
        this.forEach(countByteProcedure);
        return countByteProcedure.getCount();
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.delegate.anySatisfy(BytePredicates.and(this.predicate, predicate));
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.noneSatisfy(BytePredicates.not(predicate));
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public byte[] toArray() {
        final byte[] array = new byte[this.size()];
        this.forEach(new ByteProcedure(){
            private int index = 0;

            public void value(byte each) {
                array[this.index++] = each;
            }
        });
        return array;
    }

    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public MutableByteList toList() {
        return ByteArrayList.newList(this);
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSet(this);
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBag(this);
    }

    private static final class SelectByteIterator
    implements ByteIterator {
        private final ByteIterator iterator;
        private final BytePredicate predicate;
        private byte next;
        private boolean verifiedHasNext = false;

        private SelectByteIterator(ByteIterable iterable, BytePredicate predicate) {
            this(iterable.byteIterator(), predicate);
        }

        private SelectByteIterator(ByteIterator iterator, BytePredicate predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        public boolean hasNext() {
            if (this.verifiedHasNext) {
                return true;
            }
            while (this.iterator.hasNext()) {
                byte temp = this.iterator.next();
                if (!this.predicate.accept(temp)) continue;
                this.next = temp;
                this.verifiedHasNext = true;
                return true;
            }
            return false;
        }

        public byte next() {
            if (this.verifiedHasNext || this.hasNext()) {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }

    private final class IfByteProcedure
    implements ByteProcedure {
        private static final long serialVersionUID = 1L;
        private final ByteProcedure procedure;

        private IfByteProcedure(ByteProcedure procedure) {
            this.procedure = procedure;
        }

        public void value(byte each) {
            if (SelectByteIterable.this.predicate.accept(each)) {
                this.procedure.value(each);
            }
        }
    }

    private static final class CountByteProcedure
    implements ByteProcedure {
        private static final long serialVersionUID = 1L;
        private final BytePredicate predicate;
        private int counter = 0;

        private CountByteProcedure(BytePredicate predicate) {
            this.predicate = predicate;
        }

        public void value(byte each) {
            if (this.predicate.accept(each)) {
                ++this.counter;
            }
        }

        public int getCount() {
            return this.counter;
        }
    }
}

