/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.factory.primitive.FloatLists;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseFloatIterable;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableFloatSingletonList
implements ImmutableFloatList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final float element1;

    ImmutableFloatSingletonList(float element) {
        this.element1 = element;
    }

    @Override
    public float get(int index) {
        if (index == 0) {
            return this.element1;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
    }

    @Override
    public float getFirst() {
        return this.element1;
    }

    @Override
    public float getLast() {
        return this.element1;
    }

    @Override
    public int indexOf(float value) {
        return Float.compare(this.element1, value) == 0 ? 0 : -1;
    }

    @Override
    public int lastIndexOf(float value) {
        return Float.compare(this.element1, value) == 0 ? 0 : -1;
    }

    @Override
    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator(FloatArrayList.newListWith(this.element1).floatIterator());
    }

    @Override
    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(FloatProcedure procedure) {
        procedure.value(this.element1);
    }

    @Override
    public void forEachWithIndex(FloatIntProcedure procedure) {
        procedure.value(this.element1, 0);
    }

    @Override
    public int count(FloatPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    @Override
    public ImmutableFloatList select(FloatPredicate predicate) {
        return predicate.accept(this.element1) ? FloatArrayList.newListWith(this.element1).toImmutable() : new FloatArrayList().toImmutable();
    }

    @Override
    public ImmutableFloatList reject(FloatPredicate predicate) {
        return predicate.accept(this.element1) ? new FloatArrayList().toImmutable() : FloatArrayList.newListWith(this.element1).toImmutable();
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    @Override
    public <V> ImmutableList<V> collect(FloatToObjectFunction<? extends V> function) {
        return FastList.newListWith(function.valueOf(this.element1)).toImmutable();
    }

    @Override
    public double sum() {
        return this.element1;
    }

    @Override
    public float max() {
        return this.element1;
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        return this.element1;
    }

    @Override
    public float min() {
        return this.element1;
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        return this.element1;
    }

    @Override
    public double average() {
        return this.element1;
    }

    @Override
    public double median() {
        return this.element1;
    }

    @Override
    public float[] toSortedArray() {
        return new float[]{this.element1};
    }

    @Override
    public MutableFloatList toSortedList() {
        return FloatArrayList.newListWith(this.element1);
    }

    @Override
    public int binarySearch(float value) {
        if (Float.compare(this.element1, value) == 0) {
            return 0;
        }
        if (Float.compare(this.element1, value) < 0) {
            return -2;
        }
        return -1;
    }

    @Override
    public double dotProduct(FloatList list) {
        if (list.size() != 1) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return (double)this.element1 * (double)list.getFirst();
    }

    @Override
    public float[] toArray() {
        return new float[]{this.element1};
    }

    @Override
    public boolean contains(float value) {
        return Float.compare(this.element1, value) == 0;
    }

    @Override
    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (Float.compare(this.element1, value) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (Float.compare(this.element1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public LazyFloatIterable asReversed() {
        return ReverseFloatIterable.adapt(this);
    }

    @Override
    public MutableFloatList toList() {
        return FloatArrayList.newListWith(this.element1);
    }

    @Override
    public MutableFloatSet toSet() {
        return FloatHashSet.newSetWith(this.element1);
    }

    @Override
    public MutableFloatBag toBag() {
        return FloatHashBag.newBagWith(this.element1);
    }

    @Override
    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter(this);
    }

    @Override
    public ImmutableFloatList toImmutable() {
        return this;
    }

    @Override
    public ImmutableFloatSingletonList toReversed() {
        return this;
    }

    @Override
    public ImmutableFloatList newWith(float element) {
        return FloatLists.immutable.with(this.element1, element);
    }

    @Override
    public ImmutableFloatList newWithout(float element) {
        return Float.compare(this.element1, element) == 0 ? FloatLists.immutable.with() : this;
    }

    @Override
    public ImmutableFloatList newWithAll(FloatIterable elements) {
        FloatArrayList arrayList = FloatArrayList.newListWith(this.element1);
        arrayList.addAll(elements);
        return arrayList.toImmutable();
    }

    @Override
    public ImmutableFloatList newWithoutAll(FloatIterable elements) {
        return elements.contains(this.element1) ? FloatLists.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.element1);
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectFloatIntToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.element1, 0);
    }

    @Override
    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof FloatList)) {
            return false;
        }
        FloatList list = (FloatList)otherList;
        if (list.size() != 1) {
            return false;
        }
        return Float.compare(this.element1, list.get(0)) == 0;
    }

    @Override
    public int hashCode() {
        return 31 + Float.floatToIntBits(this.element1);
    }

    @Override
    public String toString() {
        return "[" + this.element1 + ']';
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ImmutableFloatList distinct() {
        return this;
    }

    @Override
    public ImmutableFloatList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}

