/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.list.primitive.ShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.factory.primitive.ShortLists;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseShortIterable;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableShortArrayList
implements ImmutableShortList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final short[] items;

    private ImmutableShortArrayList(short[] newElements) {
        if (newElements.length <= 1) {
            throw new IllegalArgumentException("Use ShortLists.immutable.with() to instantiate an optimized collection");
        }
        this.items = newElements;
    }

    public static ImmutableShortArrayList newList(ShortIterable iterable) {
        return new ImmutableShortArrayList(iterable.toArray());
    }

    public static ImmutableShortArrayList newListWith(short ... elements) {
        short[] newArray = new short[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableShortArrayList(newArray);
    }

    @Override
    public short get(int index) {
        return this.items[index];
    }

    @Override
    public short getFirst() {
        return this.items[0];
    }

    @Override
    public short getLast() {
        return this.items[this.items.length - 1];
    }

    @Override
    public int indexOf(short value) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(short value) {
        for (int i = this.items.length - 1; i >= 0; --i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    @Override
    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ShortProcedure procedure) {
        for (short item : this.items) {
            procedure.value(item);
        }
    }

    @Override
    public void forEachWithIndex(ShortIntProcedure procedure) {
        for (int i = 0; i < this.items.length; ++i) {
            procedure.value(this.items[i], i);
        }
    }

    @Override
    public int count(ShortPredicate predicate) {
        int count = 0;
        for (short item : this.items) {
            if (!predicate.accept(item)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        for (short item : this.items) {
            if (!predicate.accept(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        for (short item : this.items) {
            if (predicate.accept(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        for (short item : this.items) {
            if (!predicate.accept(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ImmutableShortList select(ShortPredicate predicate) {
        ShortArrayList result = new ShortArrayList();
        for (short item : this.items) {
            if (!predicate.accept(item)) continue;
            result.add(item);
        }
        return result.toImmutable();
    }

    @Override
    public ImmutableShortList reject(ShortPredicate predicate) {
        ShortArrayList result = new ShortArrayList();
        for (short item : this.items) {
            if (predicate.accept(item)) continue;
            result.add(item);
        }
        return result.toImmutable();
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        for (short item : this.items) {
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    @Override
    public <V> ImmutableList<V> collect(ShortToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.items.length);
        for (short item : this.items) {
            target.add(function.valueOf(item));
        }
        return target.toImmutable();
    }

    @Override
    public long sum() {
        long result = 0L;
        for (short item : this.items) {
            result += (long)item;
        }
        return result;
    }

    @Override
    public short max() {
        short max = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            short value = this.items[i];
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    @Override
    public short maxIfEmpty(short defaultValue) {
        return this.max();
    }

    @Override
    public short min() {
        short min = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            short value = this.items[i];
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    @Override
    public short minIfEmpty(short defaultValue) {
        return this.min();
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        short[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            short first = sortedArray[middleIndex];
            short second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public short[] toSortedArray() {
        short[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public long dotProduct(ShortList list) {
        if (this.size() != list.size()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        long sum = 0L;
        for (int i = 0; i < this.size(); ++i) {
            sum += (long)this.items[i] * (long)list.get(i);
        }
        return sum;
    }

    @Override
    public LazyShortIterable asReversed() {
        return ReverseShortIterable.adapt(this);
    }

    @Override
    public MutableShortList toSortedList() {
        return ShortArrayList.newList(this).sortThis();
    }

    @Override
    public int binarySearch(short value) {
        return Arrays.binarySearch(this.items, value);
    }

    @Override
    public short[] toArray() {
        short[] newItems = new short[this.items.length];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        return newItems;
    }

    @Override
    public boolean contains(short value) {
        for (short item : this.items) {
            if (item != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableShortList toList() {
        return ShortArrayList.newList(this);
    }

    @Override
    public MutableShortSet toSet() {
        return ShortHashSet.newSet(this);
    }

    @Override
    public MutableShortBag toBag() {
        return ShortHashBag.newBag(this);
    }

    @Override
    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter(this);
    }

    @Override
    public ImmutableShortList toImmutable() {
        return this;
    }

    @Override
    public ImmutableShortArrayList toReversed() {
        return ImmutableShortArrayList.newList(this.asReversed());
    }

    @Override
    public ImmutableShortList newWith(short element) {
        short[] newItems = new short[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        newItems[this.items.length] = element;
        return new ImmutableShortArrayList(newItems);
    }

    @Override
    public ImmutableShortList newWithout(short element) {
        int index = this.indexOf(element);
        if (index != -1) {
            short[] newItems = new short[this.items.length - 1];
            System.arraycopy(this.items, 0, newItems, 0, index);
            System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
            return ShortLists.immutable.with(newItems);
        }
        return this;
    }

    @Override
    public ImmutableShortList newWithAll(ShortIterable elements) {
        short[] newItems = new short[this.items.length + elements.size()];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        int index = 0;
        ShortIterator iterator = elements.shortIterator();
        while (iterator.hasNext()) {
            newItems[this.items.length + index] = iterator.next();
            ++index;
        }
        return new ImmutableShortArrayList(newItems);
    }

    @Override
    public ImmutableShortList newWithoutAll(ShortIterable elements) {
        MutableShortList mutableShortList = this.toList();
        mutableShortList.removeAll(elements);
        return mutableShortList.toImmutable();
    }

    @Override
    public int size() {
        return this.items.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i]);
        }
        return result;
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectShortIntToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i], i);
        }
        return result;
    }

    @Override
    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof ShortList)) {
            return false;
        }
        ShortList list = (ShortList)otherList;
        if (this.items.length != list.size()) {
            return false;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == list.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (short item : this.items) {
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            for (int i = 0; i < this.items.length; ++i) {
                if (i > 0) {
                    appendable.append(separator);
                }
                short value = this.items[i];
                appendable.append(String.valueOf(value));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ImmutableShortList distinct() {
        ShortArrayList target = new ShortArrayList();
        ShortHashSet seenSoFar = new ShortHashSet(this.size());
        for (short each : this.items) {
            if (!seenSoFar.add(each)) continue;
            target.add(each);
        }
        return target.toImmutable();
    }

    @Override
    public ImmutableShortList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    private class InternalShortIterator
    implements ShortIterator {
        private int currentIndex;

        private InternalShortIterator() {
        }

        public boolean hasNext() {
            return this.currentIndex != ImmutableShortArrayList.this.items.length;
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            short next = ImmutableShortArrayList.this.items[this.currentIndex];
            ++this.currentIndex;
            return next;
        }
    }
}

